<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class academico extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    public $motivo, $grupo_new, $grupo_old, $aprobados, $reprobados;

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'estudiantes',
            'grupos',
            'especialidades'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['estudiante', 'grupo','fecha_matricula'], 'required', 'on' => 'academico'],
            [['estudiante', 'grupo', 'especialidad', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado', 'grupo_new', 'grupo_old'], 'integer'],
            [['fecha_matricula', 'fecha_retiro', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['aprobo'], 'string', 'max' => 1], 
            [['motivo'], 'required', 'when' => function ($model) {
                    return $model->fecha_retiro != '';
                }, 'whenClient' => "function (attribute, value) {
                    return $('#academico-motivo').val() != '';
                }"]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'academico';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'grupo' => Yii::t('app', 'Grupo'),
            'especialidad' => Yii::t('app', 'Especialidad'),
            'fecha_matricula' => Yii::t('app', 'Fecha de Ingreso'),
            'fecha_retiro' => Yii::t('app', 'Fecha de Retiro'),
            'aprobo' => Yii::t('app', 'Aprobó'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nueva Carga Académica para <span class="text-success">'.$this->estudiantes->nombre.'</span> para el Grupo <span class="text-primary">'.$this->grupos->grupo.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Carga Académica para <span class="text-success">'.$this->estudiantes->nombre.'</span> para el Grupo <span class="text-primary">'.$this->grupos->grupo.'</span>');
        }    

    }

    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }

    public function getGrupoold()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo_old']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEspecialidades()
    {
        return $this->hasOne(\backend\models\Especialidad::className(), ['id' => 'especialidad']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
