<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Acudiente extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/


    public function relationNames()
    {
        return [
            'estudiantes',
            'generos',
            'rhs',
            'parentescos',
            'tipos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['estudiante','identificacion', 'primer_nombre', 'primer_apellido', 'genero', 'parentesco', 'rh', 'movil', 'email'], 'required'],
            [['estudiante', 'principal','parentesco', 'rh', 'creado_por', 'actualizado_por'], 'integer'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['fijo', 'movil'], 'string', 'max' => 10],
            [['primer_nombre', 'segundo_nombre', 'primer_apellido', 'segundo_apellido', 'direccion'], 'string', 'max' => 255],
            [['genero'], 'string', 'max' => 1],
            [['email'], 'email'],
            [['identificacion'], 'trim'],
            [['tipo'], 'default', 'value'=> 1],
            /*[['identificacion'], 'match', 'pattern' => '/^((\d{8})|(\d{10})|(\d{11})|(\d{6}-\d{5}))$/', 
                'message' => 'Número de Identificación no es válido.'],*/
            
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'acudiente';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'identificacion' => Yii::t('app', 'Número de Identificación'),
            'tipo' => Yii::t('app', 'Tipo de Identificación'),
            'primer_nombre' => Yii::t('app', 'Primer Nombre'),
            'segundo_nombre' => Yii::t('app', 'Segundo Nombre'),
            'primer_apellido' => Yii::t('app', 'Primer Apellido'),
            'segundo_apellido' => Yii::t('app', 'Segundo Apellido'),
            'genero' => Yii::t('app', 'Género'),
            'principal' => Yii::t('app', 'Principal'),
            'parentesco' => Yii::t('app', 'Parentesco'),
            'rh' => Yii::t('app', 'Grupo Sanguineo y Factor RH'),
            'direccion' => Yii::t('app', 'Dirección de Residencia'),
            'fijo' => Yii::t('app', 'Télefono Fijo'),
            'movil' => Yii::t('app', 'Télefono Celular'),
            'email' => Yii::t('app', 'Correo Eléctronico'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
        ];
    }

    public function getNombre()
    {
        return $this->primer_nombre.' '.$this->segundo_nombre.' '.$this->primer_apellido.' '.$this->segundo_apellido;
    }

    public function getNombreinverso()
    {
        return $this->primer_apellido.' '.$this->segundo_apellido.' '.$this->primer_nombre.' '.$this->segundo_nombre;
    }


    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGeneros()
    {
        return $this->hasOne(\backend\models\Genero::className(), ['id' => 'genero']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRhs()
    {
        return $this->hasOne(\backend\models\Rh::className(), ['id' => 'rh']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getParentescos()
    {
        return $this->hasOne(\backend\models\Parentesco::className(), ['id' => 'parentesco']);
    }

    public function getTipos()
    {
        return $this->hasOne(\backend\models\Tipodocumento::className(), ['id' => 'tipo']);
    }



    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\AcudienteQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\AcudienteQuery(get_called_class());
    }
}
