<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

/**
 * This is the base model class for table "agenda".
 *
 * @property integer $id
 * @property integer $evento
 * @property integer $grupo
 * @property string $fecha_inicio
 * @property string $fecha_fin
 * @property string $color
 * @property integer $tipo_tercero
 * @property string $creado_el
 * @property integer $creado_por
 * @property string $actualizado_el
 * @property integer $actualizado_por
 * @property integer $estado
 *
 * @property \backend\models\Tipotercero $tipoTercero
 * @property \backend\models\Grupo $grupo0
 */
class Agenda extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    public $rango;

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/
    
    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'tipoterceros',
            'grupos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['evento', 'fecha_inicio', 'fecha_fin', 'publico','estado', 'rango'], 'required'],
            [['creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['grupo', 'tipo_tercero', 'fecha_inicio', 'fecha_fin', 'creado_el', 'actualizado_el'], 'safe'],
            [['color'], 'string', 'max' => 20],
            [['evento'], 'string', 'max' => 255], 
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'agenda';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'evento' => Yii::t('app', 'Evento'),
            'grupo' => Yii::t('app', 'Grupo'),
            'fecha_inicio' => Yii::t('app', 'Fecha de Inicio'),
            'fecha_fin' => Yii::t('app', 'Fecha de Finalización'),
            'color' => Yii::t('app', 'Color'),
            'tipo_tercero' => Yii::t('app', 'Puede Verlo?'),
            'publico' => Yii::t('app', 'Publicar en la Web'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nuevo Evento <span class="text-success">'.$this->evento.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Evento <span class="text-success">'.$this->evento.'</span>');
        }    

    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTipoterceros()
    {
        return $this->hasOne(\backend\models\Tipotercero::className(), ['id' => 'tipo_tercero']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }

/**
     * @inheritdoc
     * @return type mixed
     */ 
    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\AgendaQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\AgendaQuery(get_called_class());
    }
}
