<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;


class Anexo extends \yii\db\ActiveRecord
{
    use \mootensai\relation\RelationTrait;

    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'tipos',
            'oferentes'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['oferente', 'tipo_anexo'], 'required'],
            [['oferente', 'tipo_anexo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['anexo'], 'file', 'skipOnEmpty' => true, 'extensions' => 'pdf'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'anexo';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'oferente' => Yii::t('app', 'Oferente'),
            'tipo_anexo' => Yii::t('app', 'Tipo de Anexo'),
            'anexo' => Yii::t('app', 'Anexo'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTipos()
    {
        return $this->hasOne(\backend\models\Tipoanexo::className(), ['id' => 'tipo_anexo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOferentes()
    {
        return $this->hasOne(\backend\models\Oferente::className(), ['id' => 'oferente']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
            /*'uuid' => [
                'class' => UUIDBehavior::className(),
                'column' => 'id',
            ],*/
        ];
    }
}
