<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Asignatura extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'areas',
            'grados',
            'asistencias',
            'calificaciones',
            'especialidades',
            'competencias',
            'planaulas',
            'estandares'
        ];
    }


    public function rules()
    {
        return [
            [['asignatura', 'codigo', 'intensidad', 'grado', 'area','especialidad','num_calificaciones_saber','num_calificaciones_ser','por_calificaciones_saber','por_calificaciones_ser','por_asig_area','principal'], 'required'],
            [['intensidad', 'grado', 'area','especialidad','num_calificaciones_saber','num_calificaciones_ser','por_calificaciones_saber','por_calificaciones_ser', 'por_calificaciones_psi','excluida_promocion','creado_por', 'actualizado_por', 'estado','por_asig_area','principal'], 'integer'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['asignatura'], 'string', 'max' => 255],
            [['codigo'], 'string', 'max' => 6]
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'asignatura';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'codigo' => Yii::t('app', 'Código'),
            'intensidad' => Yii::t('app', 'Intensidad'),
            'grado' => Yii::t('app', 'Grado'),
            'area' => Yii::t('app', 'Área'),
            'especialidad' => Yii::t('app', 'Especialidad'),
            'num_calificaciones_saber' => Yii::t('app', 'Número de calificaciones del saber'),
            'por_calificaciones_saber' => Yii::t('app', 'Porcentaje de calificaciones del saber'),
            'num_calificaciones_ser' => Yii::t('app', 'Número de calificaciones del ser'),
            'por_calificaciones_ser' => Yii::t('app', 'Porcentaje de calificaciones del ser'),
            'por_calificaciones_psi' => Yii::t('app', 'Porcentaje Calificación (PSI-PICA)'),
            'por_asig_area' => Yii::t('app', 'Valor Porcentual Respecto al Área'),
            'principal' => Yii::t('app', 'Principal'),
            'excluida_promocion' => Yii::t('app', 'Excluida para la Validación de la Promoción'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nueva Asignatura <span class="text-success">'.$this->asignatura.'</span> para el Grado <span class="text-primary">'.$this->grados->grado.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Asignatura <span class="text-success">'.$this->asignatura.'</span> para el Grado <span class="text-primary">'.$this->grados->grado.'</span>');
        }    

    }

    public function getAreas()
    {
        return $this->hasOne(\backend\models\Area::className(), ['id' => 'area']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsistencias()
    {
        return $this->hasMany(\backend\models\Asistencia::className(), ['asignatura' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacion::className(), ['asignatura' => 'id']);
    }


    public function getEspecialidades()
    {
        return $this->hasOne(\backend\models\Especialidad::className(), ['id' => 'especialidad']);

    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencias()
    {
        return $this->hasMany(\backend\models\Competencia::className(), ['asignatura' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlanaulas()
    {
        return $this->hasMany(\backend\models\Planaula::className(), ['asignatura' => 'id']);
    }

    public function getEstandares()
    {
        return $this->hasMany(\backend\models\Estandar::className(), ['asignatura' => 'id']);
    } 

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\AsignaturaQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\AsignaturaQuery(get_called_class());
    }
}
