<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

$path = Yii::getAlias("@vendor/elibom/src/elibom_client.php");

require($path);

use Elibom\APIClient\ElibomClient as ElibomClient;


class Asistencia extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/


    public function relationNames()
    {
        return [
            'tipoinasistencias',
            'asignaturas',
            'grupos',
            'docentes',
            'estudiantes',
            'periodos'
        ];
    }


    public function rules()
    {
        return [
            [['asignatura', 'grupo', 'periodo', 'docente', 'estudiante', 'fallas', 'tipo_inasistencia', 'creado_por', 'actualizado_por', 'eliminado_por'], 'integer'],
            [['fecha', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['asistio'], 'string', 'max' => 2],
            [['fallas', 'tipo_inasistencia'], 'required', 'when' => function($model) {
                return $model->asistio == '1';
            }],
        ];  
    }
    

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'asistencia';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'docente' => Yii::t('app', 'Docente'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'asistio' => Yii::t('app', 'Asistió'),
            'fallas' => Yii::t('app', 'Fallas'),
            'tipo_inasistencia' => Yii::t('app', 'Tipo de Inasistencia'),
            'fecha' => Yii::t('app', 'Fecha de la Inasistencia'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Eliminado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {

        if($insert)
        {
                if($this->estudiantes->notificacion != '')
                {    
                    /*
                    if(Yii::$app->mailer->compose('notifica-tercero-ausencia', ['model' => $this])
                        ->setFrom([\Yii::$app->params['supportEmail'] => \Yii::$app->name . ' robot'])
                        ->setTo($this->estudiantes->notificacion) //
                        ->setCc(\Yii::$app->params['adminEmail']) //
                        ->setSubject($this->estudiantes->nombre . ' - Inasistencia')
                        ->send())
                    {
                        Yii::$app->session->addFlash('mail', [
                            'tipo' => 'info',
                            'titulo' => 'Notificación de E-Mail',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Se notificó la ausencia del estudiante '.$this->estudiantes->nombre.' al correo electrónico '.$this->estudiantes->notificacion]);         
                    }
                    else
                    {
                        Yii::$app->session->addFlash('mail', [
                            'tipo' => 'danger',
                            'titulo' => 'Error Enviando E-Mail',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Error en el transporte de correo, contácte al administrador.']);         
                    }     
                    */

                    
                        
                    if (Yii::$app->params['sms']== true)
                    {    
                        $sms ='El estudiante '.$this->estudiantes->nombre.' no ingreso a clase de '.$this->asignaturas->asignatura.' el día de hoy';
                        
                        $elibom = new ElibomClient(Yii::$app->params['sms-user'],Yii::$app->params['sms-password']);
                        
                        $movil = (Yii::$app->params['sms-test']== false) ? $this->estudiantes->sms : Yii::$app->params['sms-test'];
                        
                        $deliveryId = $elibom->sendMessage($movil, $sms, Yii::$app->params['sms-institucion']);

                        Yii::$app->session->addFlash('sms', [
                            'tipo' => 'warning',
                            'titulo' => 'Notificación de SMS',
                            'icono' => 'fa fa-mobile',
                            'mensaje' => 'Se notificó la ausencia del estudiante '.$this->estudiantes->nombre.' por mensaje de texto al celular '.$movil]);

                    }    

                }
                else 
                {     
                    Yii::$app->session->addFlash('mensaje3', [
                            'tipo' => 'danger',
                            'titulo' => 'Notificación de E-Mail',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Oops!, no pude notificar la ausencia del estudiante '.$this->estudiantes->nombre.' porque no tenia correo electrónico.']); 
                }        
                        
        }
        parent::afterSave($insert, $changedAttributes); 
    }


    public function getTipoinasistencias()
    {
        
        if (Yii::$app->request->isAjax) 
        {
            /* PARA EL FORMULARIO DE ASISTENCIA */
            return $this->hasOne(\backend\models\Tipoinasistencia::className(), ['id' => 'tipo_inasistencia']);
        }
        else
        {
            return $this->hasOne(\backend\models\Tipoinasistencia::className(), ['id' => 'tipo_inasistencia']);
        }
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }

    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    } 
}
