<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Authitem extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    public $reporte;
    
    public function relationNames()
    {
        return [
            'authAssignments',
            'ruleName',
            'authItemChildren'
        ];
    }

    public function rules()
    {
        return [
            [['name', 'type'], 'required'],
            [['type', 'created_at', 'updated_at'], 'integer'],
            [['description', 'data'], 'string'],
            [['name', 'rule_name'], 'string', 'max' => 64]
        ];
    }


    public static function tableName()
    {
        return 'auth_item';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'name' => 'Nombre',
            'type' => 'Tipo',
            'description' => 'Descripción',
            'rule_name' => 'Regla',
            'data' => 'Datos',
        ];
    }

    public function getAuthAssignments()
    {
        return $this->hasMany(\backend\models\AuthAssignment::className(), ['item_name' => 'name']);
    }
        
    public function getRuleName()
    {
        return $this->hasOne(\backend\models\AuthRule::className(), ['name' => 'rule_name']);
    }
        
    public function getAuthItemChildren()
    {
        return $this->hasOne(\backend\models\Authitemchild::className(), ['parent' => 'name']);
    }

}
