<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
class Authrule extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    public function relationNames()
    {
        return [
            'authItems'
        ];
    }

    public function rules()
    {
        return [
            [['name'], 'required'],
            [['data'], 'string'],
            [['created_at', 'updated_at'], 'integer'],
            [['name'], 'string', 'max' => 64]
        ];
    }

    public static function tableName()
    {
        return 'auth_rule';
    }

    public function attributeLabels()
    {
        return [
            'name' => Yii::t('app', 'Name'),
            'data' => Yii::t('app', 'Data'),
        ];
    }

    public function getAuthItems()
    {
        return $this->hasMany(\backend\models\AuthItem::className(), ['rule_name' => 'name']);
    }
}
