<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Bitacora extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }

    public function relationNames()
    {
        return [
            'terceros',
            'ejecutores',
            'periodos'
        ];
    }

    public function rules()
    {
        return [
            [['tercero', 'periodo', 'ejecutor', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['periodo', 'ejecutor'], 'required'],
            [['descripcion'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['accion', 'controlador'], 'string', 'max' => 255]
        ];
    }

    
    public static function tableName()
    {
        return 'bitacora';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'accion' => Yii::t('app', 'Acción'),
            'controlador' => Yii::t('app', 'Controlador'),
            'tercero' => Yii::t('app', 'Tercero'),
            'periodo' => Yii::t('app', 'Periodo'),
            'descripcion' => Yii::t('app', 'Descripción'),
            'ejecutor' => Yii::t('app', 'Ejecutor'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    public function getTerceros()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'tercero']);
    }
        
    public function getEjecutores()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'ejecutor']);
    }
        
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
