<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Blog extends \yii\db\ActiveRecord
{
    use \mootensai\relation\RelationTrait;

    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'categorias'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['titulo', 'introduccion', 'categoria'], 'required'],
            [['categoria', 'inicio','visto', 'aprobado', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['introduccion', 'contenido'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el', 'adjuntos'], 'safe'],
            [['titulo', 'imagen'], 'string', 'max' => 255],
            //[['introduccion'], 'string', 'max' => 150]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'blog';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'titulo' => Yii::t('app', 'Título'),
            'categoria' => Yii::t('app', 'Categoria'),
            'introduccion' => Yii::t('app', 'Introducción'),
            'contenido' => Yii::t('app', 'Contenido'),
            'imagen' => Yii::t('app', 'Imagen'),
            'adjuntos' => Yii::t('app', 'Adjuntos'),
            'inicio' => Yii::t('app', 'Página de Inicio'),
            'visto' => Yii::t('app', 'Visto'),
            'aprobado' => Yii::t('app', 'Aprobado'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCategorias()
    {
        return $this->hasOne(\backend\models\Blogcategoria::className(), ['id' => 'categoria']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
