<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use backend\models\base\Grupo;
use backend\models\base\Desempeno;
use backend\models\Bitacora;
use backend\models\Asignatura;
use backend\models\Promedio;
use backend\models\Promedioarea;


class Calificacion extends \yii\db\ActiveRecord
{
    
    /* use \mootensai\relation\RelationTrait;*/

    private $_rt_softdelete;
    private $_rt_softrestore;
    public $nota_id;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'asignaturas',
            'grupos',
            'estudiantes',
            'docentes',
            'periodos',
            'calificacioncalificaciones',
            'calificacionfrds',
            'calificacionobservacionesgenerales'
        ];
    }

    
    public $calificacionxcompetencia, $tipo_calificacion, $competencia, $tercero;
    
    public function rules()
    {
    
        $rules = [];
        $rules[] = [['docente', 'estudiante', 'asignatura', 'grupo', 'periodo', 'creado_por', 'actualizado_por','eliminado_por', 'estado', 'fallas','competencia', 'tipo_calificacion', 'nota_id'], 'integer'];
        $rules[] = [['creado_el', 'actualizado_el','eliminado_el','calificacionxcompetencia', 'tipo_calificacion'], 'safe'];
        $rules[] = [['nivelacion','psi'], 'string', 'max' => 5];
        $rules[] = [['indicador'], 'string', 'max' => 20];
        $rules[] = [['saber','ser','psi', 'definitiva_saber', 'promedio_saber', 'promedio_ser','definitiva_ser', 'definitiva_periodo', 'definitiva_final_periodo', 'observacion_general', 'observacion_especifica', 'frd'], 'safe'];

        if(Yii::$app->controller->action->id == 'calificaciones' or Yii::$app->controller->action->id == 'nivelaciones')
        {

            $tipo_calificacion = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one()->grados->tipo_calificacion;


            if($tipo_calificacion == '1' && Yii::$app->controller->action->id == 'calificaciones')
            {

                $rules[] =[['saber', 'ser', 'psi','definitiva_periodo'], 'match', 'pattern' => '/^((BJ)|(B)|(A)|(S))$/', 
                'message' => 'No Válida'];
                
                /*
                $rules[] =[['saber', 'ser', 'psi','definitiva_periodo'], 'in', 'range' => [1, 2, 3], 
                'message' => 'No Válida'];
                */
                
            }


            if($tipo_calificacion == '2' && Yii::$app->controller->action->id == 'calificaciones')
            {

                $rules[] =[['saber'], 'double', 
                        'min' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->min('limite_inferior'), 
                        'max' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->max('limite_superior'), 
                         ];            
            }

            if($tipo_calificacion == '1' && Yii::$app->controller->action->id == 'nivelaciones')
            {

                $rules[] =[['nivelacion'], 'match', 'pattern' => '/^((BJ)|(B)|(A)|(S))$/', 
                'message' => 'Calificación no válida'];
            }

            if($tipo_calificacion == '2' && Yii::$app->controller->action->id == 'nivelaciones')
            {

                $rules[] =[['nivelacion'], 'double', 
                        'min' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->min('limite_inferior'), 
                        'max' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->max('limite_superior'), 
                        ];            

                $rules[] = [['nivelacion'], 'required'];         
            }
        }
        

        return $rules;            
    }


    public static function tableName()
    {
        return 'calificacion';
    }

    
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'saber' => Yii::t('app', 'Saber'),
            'ser' => Yii::t('app', 'Ser'),
            'psi' => Yii::t('app', 'Calificación PSI'),
            'promedio_ser' => Yii::t('app', 'Promedio Ser'),
            'promedio_saber' => Yii::t('app', 'Promedio Saber'),
            'promedio_psi' => Yii::t('app', 'Promedio PSI'),
            'definitiva_saber' => Yii::t('app', 'Definitiva Saber'),
            'definitiva_ser' => Yii::t('app', 'Definitiva Ser'),
            'definitiva_periodo' => Yii::t('app', 'Definitiva Periodo'),
            'definitiva_final_periodo' => Yii::t('app', 'Definitiva Final Periodo'),
            'docente' => Yii::t('app', 'Docente'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'nivelacion' => Yii::t('app', 'Nivelación'),
            'indicador' => Yii::t('app', 'Indicadores'),
            'observacion_general' => Yii::t('app', 'Observaciones Generales'),
            'observacion_especifica' => Yii::t('app', 'Observaciones Específicas'),
            'frd' => Yii::t('app', 'FRD'),
            'fallas' => Yii::t('app', 'Fallas'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    } 


    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new Bitacora();

        if($this->isNewRecord)
        {
            $asignatura = Asignatura::findOne($this->asignatura);
            
            if (Yii::$app->controller->action->id == 'calificaciones')
            {
                $bitacora->Registrar('Nueva Calificación de la Asignatura '.$asignatura->asignatura.' Periodo '.$this->periodo.' [Saber ('.$this->saber.') Ser ('.$this->ser.') PSI ('.$this->psi.')]',$this->estudiante, $this->periodo);
            }

            if (Yii::$app->controller->action->id == 'nivelaciones')
            {
                $bitacora->Registrar('Nueva Nivelación de la Asignatura '.$asignatura->asignatura.' Periodo '.$this->periodo.' [Nivelación ('.$this->nivelacion.')]',$this->estudiante, $this->periodo);
            }
        }
        else
        {
            $asignatura = Asignatura::findOne($this->asignatura);
            
            if (Yii::$app->controller->action->id == 'calificaciones')
            {
                $bitacora->Registrar('Actualizar Calificación de la Asignatura '.$asignatura->asignatura.' Periodo '.$this->periodo.' [Saber ('.$this->saber.') Ser ('.$this->ser.') PSI ('.$this->psi.')]',$this->estudiante, $this->periodo);
            }

            if (Yii::$app->controller->action->id == 'nivelaciones')
            {
                $bitacora->Registrar('Actualizar Nivelación de la Asignatura '.$asignatura->asignatura.' Periodo '.$this->periodo.' [Nivelación ('.$this->nivelacion.')]',$this->estudiante, $this->periodo);
            }    
            
        }
        
        if($this->grupos->grados->tipo_calificacion == '1')
        {
            //echo "<br>199-".$this->tipo_calificacion;
            $promedio = new Promedio;

            $total_asignaturasxarea = Asignatura::find()->where(['area' => $this->asignaturas->area])->andWhere(['grado' => $this->grupos->grado])->andWhere(['eliminado_por' => '0'])->count();
                           
            //echo "<br>tipo ".$this->grupos->grados->tipo_calificacion." est ".$this->estudiante." nota ".$this->definitiva_final_periodo." grado ".$this->grupos->grado." grupo ".$this->grupo." area ".$this->asignaturas->area." periodo ".$this->periodo;
            
            if($total_asignaturasxarea == '1')
            {
                $promedio = new Promedio;
                $promedio->getPromedioxEstudiante($this->grupos->grados->tipo_calificacion, $this->estudiante, $this->definitiva_final_periodo, $this->grupos->grado, $this->grupo, $this->asignaturas->area, $this->asignatura, $this->periodo); 
            }
        }
        else
        {
            //echo "<br>214".$this->tipo_calificacion;
            $promedio = new Promedio;
            $promedio->getPromedioxEstudiante($this->grupos->grados->tipo_calificacion, $this->estudiante, $this->definitiva_final_periodo, $this->grupos->grado, $this->grupo, $this->asignaturas->area, $this->asignatura, $this->periodo); 
        }

        //exit;

        /*echo "<br>tipo: ".$this->grupos->grados->tipo_calificacion.", est ".$this->estudiante." grad ".$this->grupos->grados->id." grupo ".$this->grupo." asig ".$this->asignatura." perio ".$this->periodo;
        echo "<br><pre>";
        print_r($this);
        echo "</pre>";
*/
        //exit;

        //$promedio->getPromedioxEstudiante($this->grupos->grados->tipo_calificacion, $this->estudiante, $this->definitiva_periodo, $this->grupos->grados->id, $this->grupo, $this->asignatura, $this->periodo);
/*
        if($this->tipo_calificacion != 1)
        {
            
            $suma_estudiante = Calificacion::find()
                                    ->select(['SUM(definitiva_periodo) as definitiva_periodo'])
                                    ->where(['estudiante' => $this->estudiante])
                                    ->andWhere(['grupo' => $this->grupo])
                                    ->andWhere(['periodo' => $this->periodo])
                                    ->groupBy(['estudiante'])
                                    ->one();
            
            $estudiante = Tercero::findOne($this->estudiante);

            $promedio_estudiante = ROUND($suma_estudiante->definitiva_periodo / $estudiante->totalasignaturas,1);
            
            try {
                    $promedio = Promedio::find()
                                    ->where(['estudiante' => $this->estudiante])
                                    ->andWhere(['grado' => $this->grupos->grados->id])
                                    ->andWhere(['grupo' => $this->grupo])
                                    ->andWhere(['periodo' => $this->periodo])
                                    ->one();

                    if(!isset($promedio))
                    {
                        $promedio = new Promedio();
                        $promedio->promedio_estudiante = $promedio_estudiante;
                        $promedio->estudiante = $this->estudiante;
                        $promedio->grado = $this->grupos->grados->id;
                        $promedio->grupo = $this->grupo;
                        $promedio->periodo = $this->periodo;
                        $promedio->save(false);
                    }
                    else
                    {
                        $promedio->promedio_estudiante = $promedio_estudiante;
                        $promedio->update(false);    
                    }

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }

            $asignaturas = Asignatura::find()->select(['id'])->where(['area' => $this->asignaturas->area])->andWhere(['grado' => $this->grupos->grados->id]);

            $promedio_area = Calificacion::find()
                                ->select(['AVG(definitiva_final_periodo) as definitiva_final_periodo'])
                                ->where(['estudiante' => $this->estudiante])
                                ->andWhere(['grupo' => $this->grupo])
                                ->andWhere(['periodo' => $this->periodo])
                                ->andWhere(['asignatura' => $asignaturas])
                                ->groupBy(['estudiante'])
                                ->one();      

            //echo "<br>".$promedio_area->createCommand()->getRawSql();

            try {
                    $promedio = promedioarea::find()
                                    ->where(['estudiante' => $this->estudiante])
                                    ->andWhere(['grado' => $this->grupos->grados->id])
                                    ->andWhere(['grupo' => $this->grupo])
                                    ->andWhere(['area' => $this->asignaturas->area])
                                    ->andWhere(['periodo' => $this->periodo])
                                    ->one();

                    if(!isset($promedio))
                    {
                        $promedio = new promedioarea();
                        $promedio->promedio_estudiante = $promedio_area->definitiva_final_periodo;
                        $promedio->estudiante = $this->estudiante;
                        $promedio->grado = $this->grupos->grados->id;
                        $promedio->grupo = $this->grupo;
                        $promedio->area = $this->asignaturas->area;
                        $promedio->periodo = $this->periodo;
                        $promedio->save(false);
                    }
                    else
                    {
                        $promedio->promedio_estudiante = $promedio_area->definitiva_final_periodo;
                        $promedio->update(false);    
                    }

            } catch (\yii\db\IntegrityException $e) {
                return $promedio->error_reporting();

            }
        
                        
        }    
*/
        parent::afterSave($insert, $changedAttributes); 
    }

    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }

    public function getCalificacioncalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacioncalificaciones::className(), ['calificacion' => 'id']);
    }
    
    public function getCalificacionfrds()
    {
        return $this->hasMany(\backend\models\Calificacionfrd::className(), ['calificacion' => 'id']);
    }
        
    public function getCalificacionobservacionesgenerales()
    {
        return $this->hasMany(\backend\models\Calificacionobservacionesgenerales::className(), ['calificacion' => 'id']);
    } 


    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
