<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Calificacioncompromisos extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'docentes',
            'estudiantes',
            'grupos',
            'periodos'
        ];
    }

    public function rules()
    {
    
        $rules = [];
        $rules[] = [['docente', 'estudiante', 'grupo', 'periodo', 'creado_por', 'actualizado_por','eliminado_por', 'estado',  'tipo_calificacion', 'nota_id'], 'integer'];
        $rules[] = [['creado_el', 'actualizado_el','eliminado_el','calificacionxcompetencia', 'tipo_calificacion'], 'safe'];
        $rules[] = [['nivelacion','psi'], 'string', 'max' => 5];
        $rules[] = [['indicador'], 'string', 'max' => 20];
        $rules[] = [['valoracion','ser','psi', 'definitiva_saber', 'promedio_saber', 'promedio_ser','definitiva_ser', 'definitiva_periodo', 'definitiva_final_periodo', 'observacion_general', 'observacion_especifica', 'frd'], 'safe'];


        $tipo_calificacion = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one()->grados->tipo_calificacion;


        if($tipo_calificacion == '1')
        {
            $rules[] =[['valoracion'], 'match', 'pattern' => '/^((BJ)|(B)|(A)|(S))$/', 
            'message' => 'No Válida'];            
        }


        if($tipo_calificacion == '2')
        {
            $rules[] =[['valoracion'], 'double', 
                    'min' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->min('limite_inferior'), 
                    'max' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->max('limite_superior'), 
                     ];            
        }

    
        

        return $rules;            
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'calificacion_compromisos';
    }


    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'valoracion' => Yii::t('app', 'Calificación'),
            'docente' => Yii::t('app', 'Docente'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'observacion' => Yii::t('app', 'Observaciones'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
        ];
    } 
    
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
