<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

/**
 * This is the base model class for table "calificacion_frd".
 *
 * @property integer $id
 * @property integer $calificacion
 * @property integer $frd
 * @property integer $docente
 * @property integer $estudiante
 * @property integer $grupo
 * @property integer $asignatura
 * @property integer $periodo
 * @property integer $competencia
 * @property integer $calificacion_numero
 * @property string $creado_el
 * @property integer $creado_por
 * @property string $actualizado_el
 * @property integer $actualizado_por
 * @property string $eliminado_el
 * @property integer $eliminado_por
 * @property integer $estado
 *
 * @property \backend\models\Asignatura $asignatura0
 * @property \backend\models\Grupo $grupo0
 * @property \backend\models\Tercero $estudiante0
 * @property \backend\models\Tercero $docente0
 * @property \backend\models\Periodo $periodo0
 * @property \backend\models\Competencia $competencia0
 * @property \backend\models\Calificacion $calificacion0
 * @property \backend\models\Frd $frd0
 */
class Calificacionfrd extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'asignaturas',
            'grupos',
            'estudiantes',
            'docentes',
            'periodos',
            'competencias',
            'calificaciones',
            'frds'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['calificacion', 'frd', 'docente', 'estudiante', 'grupo', 'asignatura', 'periodo'], 'required'],
            [['calificacion', 'frd', 'docente', 'estudiante', 'grupo', 'asignatura', 'periodo', 'competencia', 'calificacion_numero', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'calificacion_frd';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'calificacion' => Yii::t('app', 'Calificación Id'),
            'frd' => Yii::t('app', 'FRD'),
            'docente' => Yii::t('app', 'Docente'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'grupo' => Yii::t('app', 'Grupo'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'periodo' => Yii::t('app', 'Periodo'),
            'competencia' => Yii::t('app', 'Competencia'),
            'calificacion_numero' => Yii::t('app', 'Calificación Número'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencias()
    {
        return $this->hasOne(\backend\models\Competencia::className(), ['id' => 'competencia']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificaciones()
    {
        return $this->hasOne(\backend\models\Calificacion::className(), ['id' => 'calificacion']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFrds()
    {
        return $this->hasOne(\backend\models\Frd::className(), ['id' => 'frd']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
