<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

/**
 * This is the base model class for table "calificacionxcompetencia".
 *
 * @property integer $id
 * @property string $calificacion
 * @property integer $docente
 * @property integer $estudiante
 * @property integer $competencia
 * @property integer $asignatura
 * @property integer $grupo
 * @property integer $periodo
 * @property string $creado_el
 * @property integer $creado_por
 * @property string $actualizado_el
 * @property integer $actualizado_por
 * @property integer $estado
 *
 * @property \backend\models\Asignatura $asignatura0
 * @property \backend\models\Grupo $grupo0
 * @property \backend\models\Tercero $estudiante0
 * @property \backend\models\Tercero $docente0
 * @property \backend\models\Periodo $periodo0
 * @property \backend\models\Competencia $competencia0
 */
class Calificacionxcompetencia extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'asignatura0',
            'grupo0',
            'estudiante0',
            'docente0',
            'periodo0',
            'competencia0'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['docente', 'estudiante', 'competencia', 'asignatura', 'grupo', 'periodo'], 'required'],
            [['docente', 'estudiante', 'competencia', 'asignatura', 'grupo', 'periodo', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['calificacion'], 'string', 'max' => 5]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'calificacionxcompetencia';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Id',
            'calificacion' => 'Calificación',
            'docente' => 'Docente',
            'estudiante' => 'Estudiante',
            'competencia' => 'Competencia',
            'asignatura' => 'Asignatura',
            'grupo' => 'Grupo',
            'periodo' => 'Periodo',
            'creado_el' => 'Creado El',
            'creado_por' => 'Creado Por',
            'actualizado_el' => 'Actualizado El',
            'actualizado_por' => 'Actualizado Por',
            'estado' => 'Estado',
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignatura0()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupo0()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEstudiante0()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocente0()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodo0()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencia0()
    {
        return $this->hasOne(\backend\models\Competencia::className(), ['id' => 'competencia']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
