<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Campana extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    public $resumen;
    public $agregar;
    public $rango;
    public $destinatarios;

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;
    
    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/


    public function relationNames()
    {
        return [
            'tipos',
            'grados',
            'grupos',
            'items',
            'votos'
        ];
    }


    public function rules()
    {
        return [
            [['campana', 'fecha_inicio', 'fecha_fin', 'estado'], 'required'],
            [['tipo', 'grado', 'grupo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['fecha_inicio', 'fecha_fin', 'creado_el', 'actualizado_el', 'eliminado_el', 'destinatarios'], 'safe'],
            [['campana'], 'string', 'max' => 255]
        ];
    }


    public static function tableName()
    {
        return 'campana';
    }


    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'campana' => Yii::t('app', 'Campaña'),
            'tipo' => Yii::t('app', 'Tipo de Campaña'),
            'grado' => Yii::t('app', 'Grado'),
            'grupo' => Yii::t('app', 'Grupo'),
            'fecha_inicio' => Yii::t('app', 'Fecha de Inicio'),
            'fecha_fin' => Yii::t('app', 'Fecha de Finalización'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
            'resumen' => Yii::t('app', 'Resumen'),
            'agregar' => Yii::t('app', 'Agregar'),
            'destinatarios' => Yii::t('app', 'Destinatarios'),
        ];
    }
    
    
    public function getTipos()
    {
        return $this->hasOne(\backend\models\Campanatipo::className(), ['id' => 'tipo']);
    }
       

    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }
       

    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
       

    public function getItems()
    {
        return $this->hasMany(\backend\models\Campanaitem::className(), ['campana' => 'id']);
    }
       

    public function getVotos()
    {
        return $this->hasMany(\backend\models\Campanavoto::className(), ['campana' => 'id']);
    }
    

    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
