<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Campanaitem extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    public $total_votos;

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/


    public function relationNames()
    {
        return [
            'campanas',
            'terceros',
            'votos'
        ];
    }

 
    public function rules()
    {
        return [
            [['campana', 'tercero'], 'required'],
            [['campana', 'tercero', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['mensaje'], 'string'],
            [['adjunto','creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['foto'], 'string', 'max' => 255]
        ];
    }


    public static function tableName()
    {
        return 'campana_item';
    }


    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'campana' => Yii::t('app', 'Campaña'),
            'tercero' => Yii::t('app', 'Tercero'),
            'mensaje' => Yii::t('app', 'Propuestas'),
            'adjunto' => Yii::t('app', 'Adjunto'),
            'foto' => Yii::t('app', 'Foto'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    public function getCampanas()
    {
        return $this->hasOne(\backend\models\Campana::className(), ['id' => 'campana']);
    }
        
    public function getTerceros()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'tercero']);
    }
        
    public function getVotos()
    {
        return $this->hasMany(\backend\models\Campanavoto::className(), ['item' => 'id']);
    }
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
