<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Campanatipo extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    public function relationNames()
    {
        return [
            'campanas',
            'tipos'
        ];
    }

    public function rules()
    {
        return [
            [['tipo_tercero'], 'required'],
            [['tipo_tercero', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['tipo'], 'string', 'max' => 255]
        ];
    }

    public static function tableName()
    {
        return 'campana_tipo';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'tipo' => Yii::t('app', 'Tipo'),
            'tipo_tercero' => Yii::t('app', 'Tipo de Tercero'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    

    public function getCampanas()
    {
        return $this->hasMany(\backend\models\Campana::className(), ['tipo' => 'id']);
    }
        
    
    public function getTipos()
    {
        return $this->hasOne(\backend\models\TipoTercero::className(), ['id' => 'tipo_tercero']);
    }
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
