<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Campanavoto extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

 
    public function relationNames()
    {
        return [
            'campanas',
            'items'
        ];
    }


    public function rules()
    {
        return [
            [['campana', 'item', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['item', 'estado'], 'required'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    public static function tableName()
    {
        return 'campana_voto';
    }


    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'campana' => Yii::t('app', 'Campaña'),
            'item' => Yii::t('app', 'Item'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    

    public function getCampanas()
    {
        return $this->hasOne(\backend\models\Campana::className(), ['id' => 'campana']);
    }
        

    public function getItems()
    {
        return $this->hasOne(\backend\models\CampanaItem::className(), ['id' => 'item']);
    }
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
