<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Carga extends \yii\db\ActiveRecord
{

    public $sede, $grado;

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'docentes',
            'asignaturas',
            'grupos'
        ];
    } 

    
    public function rules()
    {
        return [
            [['docente', 'asignatura', 'grupo', 'director_area'], 'required'],
            [['docente', 'asignatura', 'grupo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado', 'director_area'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ]; 
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'carga';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'docente' => Yii::t('app', 'Docente'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'grupo' => Yii::t('app', 'Grupo'),
            'director_area' => Yii::t('app', 'Director del Área'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ]; 
    }

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nueva Carga Docente para <span class="text-success">'.$this->docentes->nombre.'</span> para la Asignatura <span class="text-primary">'.$this->asignaturas->asignatura.'</span> y el Grupo <span class="text-primary">'.$this->grupos->grupo.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Carga Docente para <span class="text-success">'.$this->docentes->nombre.'</span> para la Asignatura <span class="text-primary">'.$this->asignaturas->asignatura.'</span> y el Grupo <span class="text-primary">'.$this->grupos->grupo.'</span>');
        }    

    }

    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }

/**
     * @inheritdoc
     * @return type mixed
     */ 
    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

}
