<?php

namespace backend\models\base;

use Yii;
use backend\models\User;
use yii\base\Model;
use kartik\password\StrengthValidator;

class ChangePasswordForm extends Model
{
	public $username;
	public $oldPassword;
	public $newPassword;
	public $retypePassword;

	public function rules()
	{
		return [
			[['oldPassword', 'newPassword', 'retypePassword'], 'required'],
			[['newPassword', 'retypePassword'], StrengthValidator::className(), 'preset'=>'normal', 'userAttribute'=>'username'],
			[['oldPassword'], 'validatePassword'],[['newPassword'], 'safe'],
			[['retypePassword'], 'compare', 'compareAttribute' => 'newPassword'],
		];
	}

	public function attributeLabels()
    {
        return [
            'oldPassword' => Yii::t('app', 'Contraseña Actual'),
            'newPassword' => Yii::t('app', 'Contraseña Nueva'),
            'retypePassword' => Yii::t('app', 'Repetir Contraseña'),
        ];
    }

	public function validatePassword()
	{
		$user = Yii::$app->user->identity;

		if (!$user || !$user->validatePassword($this->oldPassword))
		{
			$this->addError('oldPassword', 'Contraseña actual incorrecta.');
		}
	}
    
    public function change()
	{
		if ($this->validate()) 
		{
			$user = Yii::$app->user->identity;
            $user->setPassword($this->newPassword);
            $user->generateAuthKey();

            if ($user->save()) {
            	return true;
            }
        }

		return false;
    }
}