<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Competencia extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    
    public function relationNames()
    {
        return [
            'asignaturas',
            'periodos',
            'grados',
            'estandares',
            'frds',
            'nivels',
            'planaulas',
            'planmejoramientos'
        ];
    }

   
    public function rules()
    {
        return [
            [['competencia', 'grado', 'asignatura', 'periodo'], 'required'],
            [['competencia'], 'string'],
            [['grado', 'asignatura', 'periodo', 'estandar', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    
    public static function tableName()
    {
        return 'competencia';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'competencia' => Yii::t('app', 'Competencia'),
            'grado' => Yii::t('app', 'Grado'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'periodo' => Yii::t('app', 'Periodo'),
            'estandar' => Yii::t('app', 'Estandar'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
      
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
        
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }
        
    public function getEstandares()
    {
        return $this->hasOne(\backend\models\Estandar::className(), ['id' => 'estandar']);
    }
        
    public function getFrds()
    {
        return $this->hasMany(\backend\models\Frd::className(), ['competencia' => 'id']);
    }
        
    public function getNivels()
    {
        return $this->hasMany(\backend\models\Nivel::className(), ['competencia' => 'id']);
    }
        
    public function getPlanaulas()
    {
        return $this->hasMany(\backend\models\Planaula::className(), ['competencia' => 'id']);
    }
        
    public function getPlanmejoramientos()
    {
        return $this->hasMany(\backend\models\Planmejoramiento::className(), ['competencia' => 'id']);
    }
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
