<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use backend\models\base\Grupo;
use backend\models\base\Desempeno;


class Comportamiento extends \yii\db\ActiveRecord
{
    
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'grupos',
            'estudiantes',
            'docentes',
            'periodos',
            'comportamientos'
        ];
    }

    
    public $calificacionxcompetencia, $tipo_calificacion, $comportamiento;
    
    public function rules()
    {
    
        $rules = [];
        $rules[] = [['docente', 'estudiante', 'comportamiento', 'grupo', 'periodo', 'creado_por', 'actualizado_por','eliminado_por', 'estado'], 'integer'];
        $rules[] = [['creado_el', 'actualizado_el','eliminado_el','calificacionxcompetencia', 'tipo_calificacion'], 'safe'];
        $rules[] = [['calificacion', 'definitiva', 'observacion_general', 'observacion_especifica'], 'safe'];

        $tipo_calificacion = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one()->grados->tipo_calificacion;

        if($tipo_calificacion == '1' && Yii::$app->controller->action->id == 'calificaciones')
        {

            $rules[] =[['calificacion', 'definitiva'], 'match', 'pattern' => '/^((NE)|(BJ)|(B)|(A)|(S))$/', 
            'message' => 'No Válida'];
            
            /*
            $rules[] =[['saber', 'ser', 'psi','definitiva_periodo'], 'in', 'range' => [1, 2, 3], 
            'message' => 'No Válida'];
            */
            
        }

        if($tipo_calificacion == '2' && Yii::$app->controller->action->id == 'comportamiento')
        {

            $rules[] =[['calificacion'], 'double', 
                    'min' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->min('limite_inferior'), 
                    'max' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->max('limite_superior'), 
                     ];            
        }
        

        return $rules;            
    }


    public static function tableName()
    {
        return 'comportamiento';
    }

    
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'calificacion' => Yii::t('app', 'Calificación'),
            'comportamiento' => Yii::t('app', 'Comportamiento'),
            'docente' => Yii::t('app', 'Docente'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'observacion_general' => Yii::t('app', 'Observaciones Generales'),
            'observacion_especifica' => Yii::t('app', 'Observaciones Específicas'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ]; 
    } 

    public function getComportamientos()
    {
        return $this->hasOne(\backend\models\ComportamientoEstudiante::className(), ['id' => 'comportamiento']);
    } 
        
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
        
    public function getCalificacionobservacionesgenerales()
    {
        return $this->hasMany(\backend\models\Calificacionobservacionesgenerales::className(), ['calificacion' => 'id']);
    } 


    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
