<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Condicionpromocion extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'tipos',
            'grados',
            'areas',
            'asignaturas',
            'desempenos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tipo'], 'required'],
            [['tipo', 'grado', 'area', 'asignatura', 'desempeno', 'numero_areas', 'numero_asignaturas', 'numero_ausentismo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['descripcion'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],

            // CONDICIÓN DE ÁREA
            [['grado', 'area', 'desempeno'], 'required', 'when' => function ($model) {
                return $model->tipo == '1';
            }, 'whenClient' => "function (attribute, value) {
                return $('#condicionpromocion-tipo').val() == '1';
            }"],

            // CONDICIÓN DE ASIGNATURA
            [['grado', 'asignatura', 'desempeno'], 'required', 'when' => function ($model) {
                return $model->tipo == '2';
            }, 'whenClient' => "function (attribute, value) {
                return $('#condicionpromocion-tipo').val() == '2';
            }"],

            // CONDICIÓN DE MÁXIMO DE AREAS PERDIDAS
            [['numero_areas'], 'required', 'when' => function ($model) {
                return $model->tipo == '3';
            }, 'whenClient' => "function (attribute, value) {
                return $('#condicionpromocion-tipo').val() == '3';
            }"],

            // CONDICIÓN DE MÁXIMO DE ASIGNATURAS PERDIDAS
            [['numero_asignaturas'], 'required', 'when' => function ($model) {
                return $model->tipo == '4';
            }, 'whenClient' => "function (attribute, value) {
                return $('#condicionpromocion-tipo').val() == '4';
            }"],

            // CONDICIÓN DE MÁXIMO DE AUSENTISMO
            [['numero_ausentismo'], 'required', 'when' => function ($model) {
                return $model->tipo == '5';
            }, 'whenClient' => "function (attribute, value) {
                return $('#condicionpromocion-tipo').val() == '5';
            }"],

        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'condicion_promocion';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'tipo' => Yii::t('app', 'Tipo de Condición'),
            'grado' => Yii::t('app', 'Grado'),
            'area' => Yii::t('app', 'Área'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'desempeno' => Yii::t('app', 'Desempeño'),
            'numero_areas' => Yii::t('app', 'Número de Áreas'),
            'numero_asignaturas' => Yii::t('app', 'Número de Asignaturas'),
            'numero_ausentismo' => Yii::t('app', 'Número de Ausentismo'),
            'descripcion' => Yii::t('app', 'Descripción'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTipos()
    {
        return $this->hasOne(\backend\models\TipoCondicion::className(), ['id' => 'tipo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAreas()
    {
        return $this->hasOne(\backend\models\Area::className(), ['id' => 'area']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDesempenos()
    {
        return $this->hasOne(\backend\models\Desempeno::className(), ['id' => 'desempeno']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
