<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class desempeno extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'tipoCalificaciones',
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['desempeno', 'tipo_calificacion', 'nota', 'perdido'], 'required'],
            [['tipo_calificacion', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado', 'perdido'], 'integer'],
            [['limite_inferior', 'limite_superior'], 'number'],
            [['creado_el', 'actualizado_el', 'eliminado_el','emoticons'], 'safe'],
            [['desempeno'], 'string', 'max' => 255],
            [['color'], 'string', 'max' => 10],
            [['nota'], 'string', 'max' => 5]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'desempeno';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'desempeno' => Yii::t('app', 'Desempeño'),
            'tipo_calificacion' => Yii::t('app', 'Tipo de Calificación'),
            'limite_inferior' => Yii::t('app', 'Límite Inferior'),
            'limite_superior' => Yii::t('app', 'Límite Superior'),
            'color' => Yii::t('app', 'Indicador de Color'),
            'nota' => Yii::t('app', 'Nota'),
            'emoticons' => Yii::t('app', 'Emoticons'),
            'perdido' => Yii::t('app', 'Perdido'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTipoCalificaciones()
    {
        return $this->hasOne(\backend\models\Tipocalificacion::className(), ['id' => 'tipo_calificacion']);
    }
        

    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
