<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Frd extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/
    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    public function relationNames()
    {
        return [
            'calificacionFrds',
            'competencias',
            'desempenos',
            'tipos',
            'niveles',
        ];
    }

    public function rules()
    {
        return [
            [['nivel', 'desempeno', 'frd_tipo'], 'required'],
            [['nivel', 'desempeno', 'frd_tipo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['descripcion'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    public static function tableName()
    {
        return 'frd';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'nivel' => Yii::t('app', 'Nivel'),
            'desempeno' => Yii::t('app', 'Desempeño'),
            'frd_tipo' => Yii::t('app', 'Tipo'),
            'descripcion' => Yii::t('app', 'Descripción'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function getCalificacionFrds()
    {
        return $this->hasMany(\backend\models\CalificacionFrd::className(), ['frd' => 'id']);
    } 
    
    public function getDesempenos()
    {
        return $this->hasOne(\backend\models\Desempeno::className(), ['id' => 'desempeno']);
    }
        
    public function getTipos()
    {
        return $this->hasOne(\backend\models\Frdtipo::className(), ['id' => 'frd_tipo']);
    }

    public function getNiveles()
    {
        return $this->hasOne(\backend\models\Nivel::className(), ['id' => 'nivel']);
    } 
   
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
