<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;

/**
 * This is the base model class for table "genero".
 *
 * @property string $id
 * @property string $genero
 *
 * @property \backend\models\Tercero[] $terceros
 */
class Genero extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'terceros'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'genero'], 'required'],
            [['id'], 'string', 'max' => 1],
            [['genero'], 'string', 'max' => 10]
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'genero';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'genero' => Yii::t('app', 'Género'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTerceros()
    {
        return $this->hasMany(\backend\models\Tercero::className(), ['genero' => 'id']);
    }

/**
     * @inheritdoc
     * @return type mixed
     */ 
    public function behaviors()
    {
        return [
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\GeneroQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\GeneroQuery(get_called_class());
    }
}
