<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Grado extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/ 

    
    public function relationNames()
    {
        return [
            'asignaturas',
            'competencias',
            'estandares',
            'tipoCalificaciones',
            'grupos',
            'planAulas'
        ];
    } 


    public function rules()
    {
        return [
            [['grado', 'codigo', 'tipo_calificacion', 'calificacionxcompetencia'], 'required'],
            [['tipo_calificacion', 'creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['grado'], 'string', 'max' => 255],
            [['codigo'], 'string', 'max' => 2]
        ];
    }
    
    public static function tableName()
    {
        return 'grado';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'grado' => Yii::t('app', 'Grado'),
            'codigo' => Yii::t('app', 'Código'),
            'tipo_calificacion' => Yii::t('app', 'Tipo de Calificación (1-Números,2-Letras)'),
            'calificacionxcompetencia' => Yii::t('app', 'Calificación por Asignatura o Competencia'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nuevo Grado <span class="text-success">'.$this->grado.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Grado <span class="text-success">'.$this->grado.'</span>');
        }    

    }

    public function getAsignaturas()
    {
        return $this->hasMany(\backend\models\Asignatura::className(), ['grado' => 'id']);
    }
        

    public function getCompetencias()
    {
        return $this->hasMany(\backend\models\Competencia::className(), ['grado' => 'id']);
    }
        

    public function getEstandares()
    {
        return $this->hasMany(\backend\models\Estandar::className(), ['grado' => 'id']);
    }
        

    public function getTipoCalificaciones()
    {
        return $this->hasOne(\backend\models\Tipocalificacion::className(), ['id' => 'tipo_calificacion']);
    }
        

    public function getGrupos()
    {
        return $this->hasMany(\backend\models\Grupo::className(), ['grado' => 'id']);
    }
        

    public function getPlanAulas()
    {
        return $this->hasMany(\backend\models\Planaula::className(), ['grado' => 'id']);
    }
    

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\GradoQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\GradoQuery(get_called_class());
    }
}
