<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Grupo extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    public function relationNames()
    {
        return [
            'academicos',
            'asistencias',
            'calificaciones',
            'calificacionCompromisos',
            'calificacionxcompetencias',
            'cargas',
            'grados',
            'metodologias',
            'modalidades',
            'especialidades',
            'sedes',
            'directores',
            'jornadas',
            'planAulas',
        ];
    } 

    public function rules()
    {
        return [
            [['grado', 'grupo', 'jornada', 'sede', 'metodologia', 'modalidad', 'especialidad'], 'required'],
            [['grado', 'director', 'jornada', 'sede', 'metodologia', 'modalidad', 'especialidad', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['grupo'], 'string', 'max' => 10]
        ];
    } 

    public static function tableName()
    {
        return 'grupo';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'grado' => Yii::t('app', 'Grado'),
            'grupo' => Yii::t('app', 'Grupo'),
            'director' => Yii::t('app', 'Director'),
            'jornada' => Yii::t('app', 'Jornada'),
            'sede' => Yii::t('app', 'Sede'),
            'metodologia' => Yii::t('app', 'Metodología'),
            'modalidad' => Yii::t('app', 'Modalidad'),
            'especialidad' => Yii::t('app', 'Especialidad'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    } 

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nuevo Grupo <span class="text-success">'.$this->grupo.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Grupo <span class="text-success">'.$this->grupo.'</span>');
        }    

    }

    public function getAcademicos()
    {
        return $this->hasMany(\backend\models\Academico::className(), ['grupo' => 'id']);
    }
        
    public function getAsistencias()
    {
        return $this->hasMany(\backend\models\Asistencia::className(), ['grupo' => 'id']);
    }
        
    public function getCalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacion::className(), ['grupo' => 'id']);
    }
        
    public function getCalificacionCompromisos()
    {
        return $this->hasMany(\backend\models\Calificacioncompromisos::className(), ['grupo' => 'id']);
    }
        
    public function getCalificacionxcompetencias()
    {
        return $this->hasMany(\backend\models\Calificacionxcompetencia::className(), ['grupo' => 'id']);
    }
        
    public function getCargas()
    {
        return $this->hasMany(\backend\models\Carga::className(), ['grupo' => 'id']);
    }
        
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }
        
    public function getMetodologias()
    {
        return $this->hasOne(\backend\models\Metodologia::className(), ['id' => 'metodologia']);
    }
        
    public function getModalidades()
    {
        return $this->hasOne(\backend\models\Modalidad::className(), ['id' => 'modalidad']);
    }
        
    public function getEspecialidades()
    {
        return $this->hasOne(\backend\models\Especialidad::className(), ['id' => 'especialidad']);
    }
        
    public function getSedes()
    {
        return $this->hasOne(\backend\models\Sede::className(), ['id' => 'sede']);
    }
        
    public function getDirectores()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'director']);
    }
        
    public function getJornadas()
    {
        return $this->hasOne(\backend\models\Jornada::className(), ['id' => 'jornada']);
    }
        
    public function getPlanAulas()
    {
        return $this->hasMany(\backend\models\Planaula::className(), ['grupo' => 'id']);
    } 

    public function getEstudiantesCount()
    {
        return Academico::find()->where(['grupo' => $this->id])->andWhere(['eliminado_por' => 0])->andWhere('fecha_retiro IS NULL')->count();
    }
    

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /*    
    public static function find()
    {
        return new \backend\models\GrupoQuery(get_called_class());
    }
    */
}
