<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Grupomatricular extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    public $direccion;

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'sedeactual',
            'gradoactual',
            'jornadaactual',
            'grupoactual',
            'sedenuevo',
            'gradonuevo',
            'jornadanuevo',
            'gruponuevo'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['sede_actual', 'grado_actual', 'jornada_actual', 'grupo_actual', 'sede_nuevo', 'grado_nuevo', 'jornada_nuevo', 'grupo_nuevo'], 'required'],
            [['sede_actual', 'grado_actual', 'jornada_actual', 'grupo_actual', 'sede_nuevo', 'grado_nuevo', 'jornada_nuevo', 'grupo_nuevo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'grupo_matricular';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'sede_actual' => Yii::t('app', 'Sede'),
            'grado_actual' => Yii::t('app', 'Grado'),
            'jornada_actual' => Yii::t('app', 'Jornada'),
            'grupo_actual' => Yii::t('app', 'Grupo'),
            'sede_nuevo' => Yii::t('app', 'Sede'),
            'grado_nuevo' => Yii::t('app', 'Grado'),
            'jornada_nuevo' => Yii::t('app', 'Jornada'),
            'grupo_nuevo' => Yii::t('app', 'Grupo'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSedeactual()
    {
        return $this->hasOne(\backend\models\Sede::className(), ['id' => 'sede_actual']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGradoactual()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado_actual']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJornadaactual()
    {
        return $this->hasOne(\backend\models\Jornada::className(), ['id' => 'jornada_actual']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupoactual()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo_actual']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSedenuevo()
    {
        return $this->hasOne(\backend\models\Sede::className(), ['id' => 'sede_nuevo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGradonuevo()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado_nuevo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJornadanuevo()
    {
        return $this->hasOne(\backend\models\Jornada::className(), ['id' => 'jornada_nuevo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGruponuevo()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo_nuevo']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
