<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;

/**
 * This is the base model class for table "jornada".
 *
 * @property integer $id
 * @property string $jornada
 * @property string $creado_el
 * @property integer $creado_por
 * @property string $actualizado_el
 * @property integer $actualizado_por
 * @property integer $estado
 *
 * @property \backend\models\Grupo[] $grupos
 */
class Jornada extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'grupos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['jornada'], 'required'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['jornada'], 'string', 'max' => 255]
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'jornada';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'jornada' => Yii::t('app', 'Jornada'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {
        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {
            $bitacora->Registrar('Nueva Jornada <span class="text-success">'.$this->jornada.'</span>');
        }
        else
        {
            $bitacora->Registrar('Actualizar Jornada <span class="text-success">'.$this->jornada.'</span>');
        }    

    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasMany(\backend\models\Grupo::className(), ['jornada' => 'id']);
    }

/**
     * @inheritdoc
     * @return type mixed
     */ 
    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\JornadaQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\JornadaQuery(get_called_class());
    }
}
