<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Mensajes extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'remitentes',
            'remisores',
            'categorias'
        ];
    }

    public $tipo, $grupo, $file_import;

    
    public function rules()
    {
        return [
            [['remisor', 'asunto', 'mensaje'], 'required'],
            [['categoria', 'importante', 'cartelera','visto', 'estado','creado_por','actualizado_por','eliminado_por'], 'integer'],
            [['mensaje', 'adjunto'], 'string'],
            [['visto_el','tipo', 'grupo','mid','remitente','creado_el','actualizado_el','eliminado_el'], 'safe'],
            [['asunto'], 'string', 'max' => 255]
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'mensajes';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'mid' => Yii::t('app', 'Mid'),
            'remitente' => Yii::t('app', 'De'),
            'remisor' => Yii::t('app', 'Para'),
            'asunto' => Yii::t('app', 'Asunto'),
            'categoria' => Yii::t('app', 'Categoría'),
            'importante' => Yii::t('app', 'Importante'),
            'cartelera' => Yii::t('app', 'Cartelera'),
            'mensaje' => Yii::t('app', 'Mensaje'),
            'adjunto' => Yii::t('app', 'Adjunto'),
            'visto' => Yii::t('app', 'Visto'),
            'visto_el' => Yii::t('app', 'Visto El'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRemitentes()
    {
        return $this->hasOne(\backend\models\base\Tercero::className(), ['id' => 'remitente']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRemisores()
    {
        return $this->hasOne(\backend\models\base\Tercero::className(), ['id' => 'remisor']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCategorias()
    {
        return $this->hasOne(\backend\models\base\Mensajescategorias::className(), ['id' => 'categoria']);
    }
    
/**
     * @inheritdoc
     * @return array mixed
     */ 
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }



    public static function getDestinatariosbyTipo($tipo = NULL, $grupo = NULL) {
        
        if($tipo == 1) //ESTUDIANTE
        {
            if($grupo == 1) // INDIVIDUAL
            {    
                $data = Tercero::find()->where(['tipo_tercero' => $tipo])->andWhere(['<', 'estado', '3'])->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido, ''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as name")])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->asArray()->all();
            }
            if($grupo == 2) // GRUPO
            {
                $data = Grupo::find()->where(['estado' => '1'])->select(['id', new \yii\db\Expression("grupo as name")])->asArray()->all();
            }
        }

        if($tipo == 2) //DOCENTE
        {
            if($grupo == 1) // INDIVIDUAL
            {    
                $data = Tercero::find()->where(['tipo_tercero' => $tipo, 'estado' => '5'])->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido, ''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as name")])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->asArray()->all();
            }
            
        }

        if($tipo == 3) //ADMINISTRATIVO
        {
            if($grupo == 1) // INDIVIDUAL
            {    
                $data = Tercero::find()->where(['tipo_tercero' => $tipo, 'estado' => '7'])->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido, ''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as name")])->orderBy(['primer_apellido' => SORT_ASC, 'segundo_apellido' => SORT_ASC, 'primer_nombre' => SORT_ASC, 'segundo_nombre' => SORT_ASC])->asArray()->all();
            }
            
        }

        if($tipo == 4) //ACUDIENTE
        {
            if($grupo == 1) // INDIVIDUAL
            {    
                //$data = Acudiente::find()->where(['tipo_tercero' => $tipo, 'estado' => '7'])->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido, ''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as name")])->asArray()->all();
            }
            else // GRUPO
            {
                //$data = Acudiente::find()->where(['tipo_tercero' => $tipo, 'estado' => '7'])->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido, ''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as name")])->asArray()->all();
            }
        }


        return $data;
    }


    public static function find()
    {
        return new \backend\models\MensajesQuery(get_called_class());
    }
}
