<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

/**
 * This is the base model class for table "message".
 *
 * @property integer $id
 * @property string $language
 * @property string $translation
 *
 * @property \backend\models\SourceMessage $id0
 */
class Message extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    
    public $message;

    public function relationNames()
    {
        return [
            'ids'
        ];
    }

    public function rules()
    {
        return [
            [['id', 'language'], 'required'],
            [['id'], 'integer'],
            [['translation'], 'string'],
            [['language'], 'string', 'max' => 16]
        ];
    }

    public static function tableName()
    {
        return 'message';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'language' => Yii::t('app', 'Language'),
            'translation' => Yii::t('app', 'Translation'),
        ];
    }
    
    public function getIds()
    {
        return $this->hasOne(\backend\models\Sourcemessage::className(), ['id' => 'id']);
    }
    
}
