<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Nivel extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'frds',
            'competencias',
            'desempenos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['competencia', 'desempeno','nivel'], 'required'],
            [['competencia', 'desempeno', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['nivel', 'recomendacion'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'nivel';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'competencia' => Yii::t('app', 'Competencia'),
            'desempeno' => Yii::t('app', 'Desempeño'),
            'nivel' => Yii::t('app', 'Nivel'),
            'recomendacion' => Yii::t('app', 'Recomendación'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFrds()
    {
        return $this->hasMany(\backend\models\Frd::className(), ['nivel' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencias()
    {
        return $this->hasOne(\backend\models\Competencia::className(), ['id' => 'competencia']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDesempenos()
    {
        return $this->hasOne(\backend\models\Desempeno::className(), ['id' => 'desempeno']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
