<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use backend\models\Mensajes;


class Observador extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/
    
    public function rules()
    {
        return [
            [['fecha','comprometidos', 'momento', 'periodo', 'clase_observacion', 'tipo_observacion', 'descripcion'], 'required'],
            [['id', 'estudiante', 'momento', 'asignatura', 'periodo', 'docente', 'clase_observacion', 'tipo_observacion', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['creado_el', 'actualizado_el','eliminado_el', 'docente'], 'safe'],
            [['descripcion', 'descargos', 'proceso'], 'string'],
            [['comprometidos'], 'safe']
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'observador';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'comprometidos' => Yii::t('app', 'Comprometidos'),
            'momento' => Yii::t('app', 'Momento'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'periodo' => Yii::t('app', 'Periodo'),
            'fecha' => Yii::t('app', 'Fecha y Hora'),
            'docente' => Yii::t('app', 'Docente'),
            'clase_observacion' => Yii::t('app', 'Clase de Observación'),
            'tipo_observacion' => Yii::t('app', 'Tipo de Observación'),
            'descripcion' => Yii::t('app', 'Descripción'),
            'descargos' => Yii::t('app', 'Descargos'),
            'proceso' => Yii::t('app', 'Proceso'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    

    public function afterSave($insert, $changedAttributes) 
    {

        if($insert)
        {

            $mensaje = new Mensajes();
            $mensaje->remitente = (Yii::$app->session->get('__tercero')=='') ? NULL : Yii::$app->session->get('__tercero');
            $mensaje->remisor = $this->estudiante;
            $mensaje->asunto = "Observación del Estudiante";
            $mensaje->categoria = '1';
            $mensaje->importante = '1';
            $mensaje->cartelera = '1';
            $mensaje->mensaje = substr($this->descripcion,0, 30)."...";
            $mensaje->estado = '1';
            $mensaje->save();

            if($this->estudiantes->notificacion != '')
            {    
                /*
                Yii::$app->mailer->compose('notifica-tercero-observacion', ['model' => $this])
                    ->setFrom([\Yii::$app->params['supportEmail'] => \Yii::$app->name . ' robot'])
                    ->setTo($this->estudiantes->notificacion) //
                    ->setSubject('Notificación de Observación')
                    ->send(); 
                
                Yii::$app->session->addFlash('mail', [
                        'tipo' => 'info',
                        'titulo' => 'Notificación de E-Mail',
                        'icono' => 'fa fa-envelope',
                        'mensaje' => 'Se notificó la observación del estudiante '.$this->estudiantes->nombre.' al correo electrónico '.$this->estudiantes->notificacion]);         
                */
                
                if (Yii::$app->params['sms']== true)
                {    
                    $sms ='El estudiante '.$this->estudiantes->nombre.' no ingreso a clase de '.$this->asignaturas->asignatura.' el día de hoy';
                    
                    $elibom = new ElibomClient(Yii::$app->params['sms-user'],Yii::$app->params['sms-password']);
                    
                    $movil = (Yii::$app->params['sms-test']== false) ? $this->estudiantes->sms : Yii::$app->params['sms-test'];
                    
                    $deliveryId = $elibom->sendMessage($movil, $sms, Yii::$app->params['sms-institucion']);

                    Yii::$app->session->addFlash('sms', [
                        'tipo' => 'warning',
                        'titulo' => 'Notificación de SMS',
                        'icono' => 'fa fa-mobile',
                        'mensaje' => 'Se notificó la observación del estudiante '.$this->estudiantes->nombre.' por mensaje de texto al celular '.$movil]);

                }    

            }
            else 
            {     
                Yii::$app->session->addFlash('mensaje3', [
                        'tipo' => 'danger',
                        'titulo' => 'Notificación de E-Mail',
                        'icono' => 'fa fa-envelope',
                        'mensaje' => 'Oops!, no pude notificar la observación del estudiante '.$this->estudiantes->nombre.' porque no tenia correo electrónico.']); 
            }        
                 
            $bitacora = new \backend\models\Bitacora;
            $bitacora->Registrar('Nuevo Observador del Estudiante <span class="text-success">'.$this->estudiantes->nombre.'</span>');
              
        }

        parent::afterSave($insert, $changedAttributes); 
    }

    public function getMomentos()
    {
        return $this->hasOne(\backend\models\Momento::className(), ['id' => 'momento']);
    } 

    public function getTipoobservacion()
    {
        return $this->hasOne(\backend\models\Tipoobservacionobservador::className(), ['id' => 'tipo_observacion']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClaseObservacion()
    {
        return $this->hasOne(\backend\models\Claseobservacionobservador::className(), ['id' => 'clase_observacion']);
    }
    
/**
     * @inheritdoc
     * @return array mixed
     */ 
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
