<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;

/**
 * This is the base model class for table "pais".
 *
 * @property string $codigo
 * @property string $pais
 * @property string $creado_el
 * @property integer $creado_por
 * @property string $actualizado_el
 * @property integer $actualizado_por
 * @property integer $estado
 */
class pais extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'terceros'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['codigo', 'pais'], 'required'],
            [['creado_el', 'actualizado_el'], 'safe'],
            [['creado_por', 'actualizado_por', 'estado'], 'integer'],
            [['codigo'], 'string', 'max' => 2],
            [['pais'], 'string', 'max' => 255]
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'pais';
    }

    public function getTerceros()
    {
        return $this->hasMany(\backend\models\Tercero::className(), ['pais' => 'codigo']);
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'codigo' => Yii::t('app', 'Código'),
            'pais' => Yii::t('app', 'País'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

/**
     * @inheritdoc
     * @return array mixed
     */ 
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
            'uuid' => [
                'class' => UUIDBehavior::className(),
                'column' => 'id',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\paisQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\PaisQuery(get_called_class());
    }
}
