<?php

namespace backend\models\base;

use Yii;

class Parametros extends \yii\db\ActiveRecord
{
    
    public function relationNames()
    {
        return [
            ''
        ];
    }

    
    public function rules()
    {
        return [
            [['mail_activo', 'google_maps_activo','online', 'google_maps_tilt', 'google_maps_zoom'], 'integer'],
            [['cloud_drive_credentials'], 'string'],
            [['mail_host', 'mail_user', 'mail_password', 'mail_port', 'mail_encryption', 'cloud_drive_defecto', 'cloud_drive_planesaula', 'cloud_drive_planesmejoramiento', 'cloud_drive_mensajes', 'cloud_drive_tareas', 'cloud_s3_key', 'cloud_s3_secret', 'cloud_s3_region', 'cloud_s3_bucket', 'mail_admin', 'mail_support', 'cookie_validation_key_front', 'cookie_validation_key_back', 'app_name', 'sms_activo', 'sms_user', 'sms_password', 'sms_institucion', 'sms_test', 'google_maps_key', 'google_maps_type'], 'string', 'max' => 255],
            [['cloud_service'], 'string', 'max' => 20]
        ];
    }

    
    public static function tableName()
    {
        return 'parametros';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'mail_activo' => Yii::t('app', 'Mail Activo'),
            'mail_host' => Yii::t('app', 'Mail Host'),
            'mail_user' => Yii::t('app', 'Mail User'),
            'mail_password' => Yii::t('app', 'Mail Password'),
            'mail_port' => Yii::t('app', 'Mail Port'),
            'mail_encryption' => Yii::t('app', 'Mail Encryption'),
            'cloud_service' => Yii::t('app', 'Cloud Service'),
            'cloud_drive_credentials' => Yii::t('app', 'Cloud Drive Credentials'),
            'cloud_drive_defecto' => Yii::t('app', 'Cloud Drive Defecto'),
            'cloud_drive_planesaula' => Yii::t('app', 'Cloud Drive Planesaula'),
            'cloud_drive_planesmejoramiento' => Yii::t('app', 'Cloud Drive Planesmejoramiento'),
            'cloud_drive_mensajes' => Yii::t('app', 'Cloud Drive Mensajes'),
            'cloud_drive_tareas' => Yii::t('app', 'Cloud Drive Tareas'),
            'cloud_s3_key' => Yii::t('app', 'Cloud S3 Key'),
            'cloud_s3_secret' => Yii::t('app', 'Cloud S3 Secret'),
            'cloud_s3_region' => Yii::t('app', 'Cloud S3 Region'),
            'cloud_s3_bucket' => Yii::t('app', 'Cloud S3 Bucket'),
            'mail_admin' => Yii::t('app', 'Mail Admin'),
            'mail_support' => Yii::t('app', 'Mail Support'),
            'cookie_validation_key_front' => Yii::t('app', 'Cookie Validation Key Front'),
            'cookie_validation_key_back' => Yii::t('app', 'Cookie Validation Key Back'),
            'app_name' => Yii::t('app', 'App Name'),
            'online' => Yii::t('app', 'Online'),
            'sms_activo' => Yii::t('app', 'Sms Activo'),
            'sms_user' => Yii::t('app', 'Sms User'),
            'sms_password' => Yii::t('app', 'Sms Password'),
            'sms_institucion' => Yii::t('app', 'Sms Institucion'),
            'sms_test' => Yii::t('app', 'Sms Test'),
            'google_maps_activo' => Yii::t('app', 'Google Maps Activo'),
            'google_maps_key' => Yii::t('app', 'Google Maps Key'),
            'google_maps_type' => Yii::t('app', 'Google Maps Type'),
            'google_maps_tilt' => Yii::t('app', 'Google Maps Tilt'),
            'google_maps_zoom' => Yii::t('app', 'Google Maps Zoom'),
        ];
    }

}
