<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Periodo extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/ 

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'asistencias',
            'bitacoras',
            'calificaciones',
            'calificacionCalificaciones',
            'calificacionCompromisos',
            'calificacionFrds',
            //'calificacionObservacionesGenerales',
            'calificacionxcompetencias',
            'competencias',
            'comportamientos',
            'comportamientoCalificaciones',
            'estandares',
            'niveles',
            'observadores',
            'planAulas',
            'planMejoramientos',
            'promedios',
            'promedioAreas'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            //[['periodo', 'habilitado'], 'required'],
            [['fecha_inicio', 'fecha_fin'], 'required'],
            [['calificaciones_inicio', 'calificaciones_fin', 'nivelaciones_inicio', 'nivelaciones_fin'], 'datetime', 'format' => 'php:Y-m-d H:i:s'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['autorizar_calificaciones', 'autorizar_nivelaciones', 'habilitado', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['periodo'], 'string', 'max' => 30],
            [['periodo'], 'required', 'on' => 'cambiar', 'message'=>'Seleccione el Periodo'],
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'periodo';
    }

    
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'periodo' => Yii::t('app', 'Periodo'),
            'fecha_inicio' => Yii::t('app', 'Fecha Inicio'),
            'fecha_fin' => Yii::t('app', 'Fecha Fin'),
            'autorizar_calificaciones' => Yii::t('app', 'Autorizar Calificaciones'),
            'calificaciones_inicio' => Yii::t('app', 'Fecha Inicio Calificaciones'),
            'calificaciones_fin' => Yii::t('app', 'Fecha Fin Calificaciones'),
            'autorizar_nivelaciones' => Yii::t('app', 'Autorizar Nivelaciones'),
            'nivelaciones_inicio' => Yii::t('app', 'Fecha Inicio Nivelaciones'),
            'nivelaciones_fin' => Yii::t('app', 'Fecha Fin Nivelaciones'),
            'habilitado' => Yii::t('app', 'Habilitado'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    public function getActual()
    {
        //SELECT * FROM `periodo` WHERE CURDATE() BETWEEN `fecha_inicio` AND `fecha_fin` 
//$query = new yii\db\Query();

        /*
        
        $query = 'SELECT id, periodo, fecha_fin FROM `periodo` WHERE CURDATE() BETWEEN `fecha_inicio` AND `fecha_fin`';
        //$query = 'SELECT id, periodo, fecha_fin FROM `periodo` WHERE id = 4';
        $model = static::findBySql($query)->one();
        return $model;*/

        /*
        if(Yii::$app->request->get('periodo'))
        {
            $periodo = static::find()->where(['id' => Yii::$app->request->get('periodo')])->one();        
        }
        else
        {
            $periodo = static::find()->where(['habilitado' => '1'])->one();        
        }
        */
        
        $periodo = static::find()->where(['habilitado' => '1'])->one();        
        
        return $periodo;
    }


public function getAsistencias()
    {
        return $this->hasMany(\backend\models\Asistencia::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBitacoras()
    {
        return $this->hasMany(\backend\models\Bitacora::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacion::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificacionCalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacioncalificaciones::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificacionCompromisos()
    {
        return $this->hasMany(\backend\models\Calificacioncompromisos::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificacionFrds()
    {
        return $this->hasMany(\backend\models\Calificacionfrd::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    /*
    public function getCalificacionObservacionesGenerales()
    {
        return $this->hasMany(\backend\models\CalificacionobservacionesGenerales::className(), ['periodo' => 'id']);
    }
    */  
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCalificacionxcompetencias()
    {
        return $this->hasMany(\backend\models\Calificacionxcompetencia::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencias()
    {
        return $this->hasMany(\backend\models\Competencia::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getComportamientos()
    {
        return $this->hasMany(\backend\models\Comportamiento::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getComportamientoCalificaciones()
    {
        return $this->hasMany(\backend\models\Comportamientocalificaciones::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEstandares()
    {
        return $this->hasMany(\backend\models\Estandar::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNiveles()
    {
        return $this->hasMany(\backend\models\Nivel::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getObservadores()
    {
        return $this->hasMany(\backend\models\Observador::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlanAulas()
    {
        return $this->hasMany(\backend\models\Planaula::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPlanMejoramientos()
    {
        return $this->hasMany(\backend\models\Planmejoramiento::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPromedios()
    {
        return $this->hasMany(\backend\models\Promedio::className(), ['periodo' => 'id']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPromedioAreas()
    {
        return $this->hasMany(\backend\models\Promedioarea::className(), ['periodo' => 'id']);
    } 

    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
