<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Planaula extends \yii\db\ActiveRecord
{
    public $sede;
    public $rango;

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'periodos',
            'docentes',
            'grados',
            'grupos',
            'asignaturas',
            'competencias'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['docente', 'semana_inicio', 'semana_fin', 'grado', 'asignatura', 'grupo', 'periodo','metodo'], 'required'],
            [['docente', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia', 'unidad', 'horas', 'creado_por', 'actualizado_por', 'estado', 'descargas','metodo'], 'integer'],
            [['semana_inicio', 'semana_fin', 'creado_el', 'actualizado_el', 'rango'], 'safe'],
            [['derechos', 'inicio', 'desarrollo', 'cierre', 'formativa', 'articulacion', 'recursos', 'reflexion', 'observaciones'], 'string'],
            [['nombre_unidad'], 'string', 'max' => 255],

            [['competencia','adjunto'], 'required', 'when' => function ($model) {
                    return $model->metodo == '1';
                }, 'whenClient' => "function (attribute, value) {
                    return $('#planaula-metodo').val() == '1';
            }"],

            [['competencia', 'unidad', 'nombre_unidad', 'horas'], 'required', 'when' => function ($model) {
                    return $model->metodo == '0';
                }, 'whenClient' => "function (attribute, value) {
                    return $('#planaula-metodo').val() == '0';
            }"],

        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'plan_aula';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'docente' => Yii::t('app', 'Docente'),
            'rango' => Yii::t('app', 'Rango'),
            'semana_inicio' => Yii::t('app', 'Semana de Inicio'),
            'semana_fin' => Yii::t('app', 'Semana de Finalización'),
            'grado' => Yii::t('app', 'Grado'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'competencia' => Yii::t('app', 'Competencia'),
            'unidad' => Yii::t('app', 'Unidad'),
            'nombre_unidad' => Yii::t('app', 'Nombre de la Unidad'),
            'horas' => Yii::t('app', 'Intensidad Horaria'),
            'derechos' => Yii::t('app', 'Derechos Básicos Asociados'),
            'inicio' => Yii::t('app', 'Actividades de Inicio (Exploración, Acercamiento a Temáticas)'),
            'desarrollo' => Yii::t('app', 'Actividades de Desarrollo (Indagación, Conceptualización)'),
            'cierre' => Yii::t('app', 'Actividades de Cierre (Aplicabilidad, Valoración)'),
            'formativa' => Yii::t('app', 'Evaluación Formativa (Técnicas, Criterios e Indicadores)'),
            'articulacion' => Yii::t('app', 'Articulación con Otras Áreas y Proyectos'),
            'recursos' => Yii::t('app', 'Recursos e Instrumentos'),
            'reflexion' => Yii::t('app', 'Reflexión'),
            'observaciones' => Yii::t('app', 'Observaciones'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
            'metodo' => Yii::t('app', 'Método'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {

        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {            
            $bitacora->Registrar('Nuevo Plan de Aula de la Asignatura "<span class="text-success">'.$this->asignaturas->asignatura.'</span>"');
        }
        else
        {
            $bitacora->Registrar('Actualizar Plan de Aula "<span class="text-success">'.$this->id.'</span>" de la Asignatura "<span class="text-success">'.$this->asignaturas->asignatura.'</span>"');
        }   

        parent::afterSave($insert, $changedAttributes); 
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencias()
    {
        return $this->hasOne(\backend\models\Competencia::className(), ['id' => 'competencia']);
    }


    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\PlanaulaQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \backend\models\PlanaulaQuery(get_called_class());
    }
}
