<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Planmejoramiento extends \yii\db\ActiveRecord
{
    public $rango, $sede, $archivo, $subir;

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'docentes',
            'grados',
            'grupos',
            'asignaturas',
            'competencias',
            'periodos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['docente', 'fecha_inicio', 'fecha_fin', 'grado', 'asignatura', 'grupo', 'periodo', 'competencia','metodo'], 'required'],
            [['docente', 'grado', 'asignatura', 'periodo', 'competencia', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado','descargas','metodo'], 'integer'],
            [['fecha_inicio', 'fecha_fin', 'creado_el', 'actualizado_el', 'eliminado_el', 'grupo'], 'safe'],
            [['tematica', 'productivo', 'cognitivo', 'valorativo', 'observaciones'], 'string'],
            
            [['adjunto'], 'required', 'when' => function ($model) {
                    return $model->metodo == '1';
                }, 'whenClient' => "function (attribute, value) {
                    return $('#metodo-id').val() == '1';
            }"],

            [['tematica', 'productivo', 'cognitivo', 'valorativo'], 'required', 'when' => function ($model) {
                    return $model->metodo == '0';
                }, 'whenClient' => "function (attribute, value) {
                    return $('#metodo-id').val() == '0';
            }"],
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'plan_mejoramiento';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'docente' => Yii::t('app', 'Docente'),
            'fecha_inicio' => Yii::t('app', 'Fecha de Inicio'),
            'fecha_fin' => Yii::t('app', 'Fecha de Finalización'),
            'grado' => Yii::t('app', 'Grado'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'competencia' => Yii::t('app', 'Competencia'),
            'tematica' => Yii::t('app', 'Unidad Temática'),
            'productivo' => Yii::t('app', 'Proceso Productivo'),
            'cognitivo' => Yii::t('app', 'Proceso Cognitivo'),
            'valorativo' => Yii::t('app', 'Proceso Valorativo'),
            'observaciones' => Yii::t('app', 'Observaciones'),
            'adjunto' => Yii::t('app', 'Adjunto'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    public function afterSave($insert, $changedAttributes) 
    {

        $bitacora = new \backend\models\Bitacora;

        if($this->isNewRecord)
        {            
            $bitacora->Registrar('Nuevo Plan de Mejoramiento de la Asignatura "<span class="text-success">'.$this->asignaturas->asignatura.'</span>"');
        }
        else
        {
            $bitacora->Registrar('Actualizar Plan de Mejoramiento "<span class="text-success">'.$this->id.'</span>" de la Asignatura "<span class="text-success">'.$this->asignaturas->asignatura.'</span>"');
        }   

        parent::afterSave($insert, $changedAttributes); 
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCompetencias()
    {
        return $this->hasOne(\backend\models\Competencia::className(), ['id' => 'competencia']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
