<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;


class Pqrsd extends \yii\db\ActiveRecord
{
    use \mootensai\relation\RelationTrait;

    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }


    public function relationNames()
    {
        return [
            'terceros',
            'tipos'
        ];
    }


    public function rules()
    {
        return [
            [['tercero', 'tipo', 'visto', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['mensaje', 'respuesta'], 'string'],
            [['adjunto_solicitud','adjunto_respuesta','visto_el', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['asunto'], 'string', 'max' => 255],

            ['email', 'filter', 'filter' => 'trim'],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            
            [['tipo','asunto','mensaje','email'], 'required', 'on' => 'registrado'],
            [['tipo','asunto','mensaje','email'], 'required', 'on' => 'anonymous'],
            [['respuesta'], 'required', 'on' => 'respuesta'],
            


            
        ];
    }


    public static function tableName()
    {
        return 'pqrsd';
    }


    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id PQRSD'),
            'tercero' => Yii::t('app', 'Tercero'),
            'asunto' => Yii::t('app', 'Asunto'),
            'tipo' => Yii::t('app', 'Tipo'),
            'email' => Yii::t('app', 'Correo Electrónico'),
            'mensaje' => Yii::t('app', 'Mensaje'),
            'adjunto_solicitud' => Yii::t('app', 'Adjunto Solicitud'),
            'respuesta' => Yii::t('app', 'Respuesta'),
            'adjunto_respuesta' => Yii::t('app', 'Adjuntos Respuesta'),
            'visto' => Yii::t('app', 'Visto'),
            'visto_el' => Yii::t('app', 'Visto El'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    

    public function getTerceros()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'tercero']);
    }
        

    public function getTipos()
    {
        return $this->hasOne(\backend\models\Tipopqrsd::className(), ['id' => 'tipo']);
    }
    

    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
            'uuid' => [
                'class' => UUIDBehavior::className(),
                'column' => 'id',
            ],
        ];
    }
}
