<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

class Promedioarea extends \yii\db\ActiveRecord
{
    public $nota_id;

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/
    

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'grados',
            'grupos',
            'estudiantes',
            'periodos',
            'areas'

        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $tipo_calificacion = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one()->grados->tipo_calificacion;

        $rules = [];
        $rules[] = [['estudiante', 'grado', 'grupo', 'periodo','area'], 'required'];
        $rules[] = [['estudiante', 'grado', 'grupo', 'periodo', 'area','creado_por', 'actualizado_por', 'eliminado_por', 'estado','nota_id'], 'integer'];
        $rules[] = [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'];
        $rules[] = [['promedio_estudiante', 'promedio_grupo', 'promedio_grado', 'promedio_area'], 'string', 'max' => 10];

        if($tipo_calificacion == '1' && Yii::$app->controller->action->id == 'area')
        {

            $rules[] =[['promedio_estudiante'], 'match', 'pattern' => '/^((BJ)|(B)|(A)|(S))$/', 
            'message' => 'Calificación no válida'];
        }
            
        return $rules;
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'promedio_area';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'promedio_estudiante' => Yii::t('app', 'Promedio Estudiante'),
            'promedio_grupo' => Yii::t('app', 'Promedio Grupo'),
            'promedio_grado' => Yii::t('app', 'Promedio Grado'),
            'promedio_area' => Yii::t('app', 'Promedio Área'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'grado' => Yii::t('app', 'Grado'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'area' => Yii::t('app', 'Área'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    
    public function getGrados()
    {
        return $this->hasOne(\backend\models\Grado::className(), ['id' => 'grado']);
    }
        
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
     
    public function getAreas()
    {
        return $this->hasOne(\backend\models\Area::className(), ['id' => 'area']);
    }
        
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
