<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;


class Religion extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/


    public function relationNames()
    {
        return [
            'terceros'
        ];
    }

    public function rules()
    {
        return [
            [['religion'], 'required'],
            [['religion'], 'string', 'max' => 30]
        ];
    }
    
    public static function tableName()
    {
        return 'religion';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'religion' => Yii::t('app', 'Grupo Religioso'),
        ];
    }

    
    public function getTerceros()
    {
        return $this->hasMany(\backend\models\Tercero::className(), ['religion' => 'id']);
    }

    public static function find()
    {
        return new \backend\models\ReligionQuery(get_called_class());
    }
}
