<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use mootensai\behaviors\UUIDBehavior;

/**
 * This is the base model class for table "rh".
 *
 * @property integer $id
 * @property string $rh
 *
 * @property \backend\models\Tercero[] $terceros
 */
class Rh extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    public function relationNames()
    {
        return [
            'terceros'
        ];
    }

    public function rules()
    {
        return [
            [['rh'], 'required'],
            [['rh'], 'string', 'max' => 3]
        ];
    }

    public static function tableName()
    {
        return 'rh';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'rh' => Yii::t('app', 'Grupo Sanguineo y Factor RH'),
        ];
    }

    public function getTerceros()
    {
        return $this->hasMany(\backend\models\Tercero::className(), ['rh' => 'id']);
    }


    public static function find()
    {
        return new \backend\models\RhQuery(get_called_class());
    }
}
