<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Sede extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'grupos',
            'departamentos',
            'municipios'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['sede', 'direccion', 'fijo', 'resolucion', 'dane', 'rector_nombre', 'rector_cc', 'rector_expedida', 'rector_movil', 'rector_email', 'calificacionxcompetencia', 'nivelacionxcompetencia', 'creado_por', 'actualizado_por', 'activar_comportamiento'], 'required'],
            [['principal', 'padre', 'num_calificaciones_saber', 'por_calificaciones_saber', 'num_calificaciones_ser', 'por_calificaciones_ser', 'psi', 'por_calificaciones_psi', 'bloquear_boletin', 'compromiso_acudiente', 'autorizar_calificaciones', 'autorizar_nivelaciones', 'bloquear_estudiante', 'fallas', 'frd', 'entrada', 'creado_por', 'actualizado_por', 'eliminado_por', 'ver_estandar', 'ver_competencia', 'ver_niveles', 'ver_desempenos', 'ver_frd', 'ver_criterios', 'ver_emoticones', 'ver_puesto', 'activar_comportamiento', 'ver_comportamiento_nota', 'observaciones_generales', 'observaciones_especificas', 'tipo_calificacion', 'activar_matriculas','nivelacion_no_nivelado', 'nivelacion_mayor_calificacion', 'orientacion'], 'integer'],
            [['pdf_header', 'pdf_footer','resolucion'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['nit'], 'string', 'max' => 15],
            [['sede', 'direccion', 'rector_email', 'rector_firma', 'logo', 'slogan', 'pdf_marcadeagua_contenido'], 'string', 'max' => 255],
            [['fijo', 'dane', 'rector_nombre', 'rector_cc', 'rector_expedida'], 'string', 'max' => 30],
            [['rector_movil'], 'string', 'max' => 10],
            [['vigencia'], 'string', 'max' => 4],
            [['mensaje'], 'string', 'max' => 255],
            [['color'], 'string', 'max' => 7],
            [['pdf_marcadeagua'], 'string', 'max' => 1]
        ]; 
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'sede';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'nit' => Yii::t('app', 'Nit'),
            'sede' => Yii::t('app', 'Sede'),
            'principal' => Yii::t('app', 'Principal'),
            'padre' => Yii::t('app', 'Padre'),
            'direccion' => Yii::t('app', 'Direccion'),
            'fijo' => Yii::t('app', 'Fijo'),
            'resolucion' => Yii::t('app', 'Resolucion'),
            'dane' => Yii::t('app', 'Dane'),
            'rector_nombre' => Yii::t('app', 'Rector Nombre'),
            'rector_cc' => Yii::t('app', 'Rector Cc'),
            'rector_expedida' => Yii::t('app', 'Rector Expedida'),
            'rector_movil' => Yii::t('app', 'Rector Movil'),
            'rector_email' => Yii::t('app', 'Rector Email'),
            'rector_firma' => Yii::t('app', 'Firma'),
            'logo' => Yii::t('app', 'Logo'),
            'slogan' => Yii::t('app', 'Slogan'),
            'vigencia' => Yii::t('app', 'Vigencia'),
            'pdf_header' => Yii::t('app', 'PDF Encabezado'),
            'pdf_footer' => Yii::t('app', 'PDF Pie de Página'),
            'pdf_marcadeagua' => Yii::t('app', 'Marca de Agua'),
            'pdf_marcadeagua_contenido' => Yii::t('app', 'Contenido Marca de Agua'),
            'tipo_calificacion' => Yii::t('app', 'Tipo de Calificación'),
            'calificacionxcompetencia' => Yii::t('app', 'Calificación por Asignatura o Competencia'),
            'nivelacionxcompetencia' => Yii::t('app', 'Nivelación por Asignatura o Competencia'),
            'nivelacion_no_nivelado' => Yii::t('app', 'Dejar definitiva del periodo si el estudiante no nivela?'),
            'nivelacion_mayor_calificacion' => Yii::t('app', 'Dejar la mayor calificación entre definitiva del periodo y nivelación?'),
            'num_calificaciones_saber' => Yii::t('app', 'Número de calificaciones del saber'),
            'por_calificaciones_saber' => Yii::t('app', 'Porcentaje de calificaciones del saber'),
            'num_calificaciones_ser' => Yii::t('app', 'Número de calificaciones del ser'),
            'por_calificaciones_ser' => Yii::t('app', 'Porcentaje de calificaciones del ser'),
            'psi' => Yii::t('app', 'Activar Pruebas de Saber Internas'),
            'por_calificaciones_psi' => Yii::t('app', 'Porcentaje Calificación (PSI-PICA)'),
            'bloquear_boletin' => Yii::t('app', 'Bloquear Descarga de Boletín'),
            'compromiso_acudiente' => Yii::t('app', 'Activar Compromiso de Acudiente'),
            'autorizar_calificaciones' => Yii::t('app', 'Autorizar Calificaciones'),
            'autorizar_nivelaciones' => Yii::t('app', 'Autorizar Nivelaciones'),
            'bloquear_estudiante' => Yii::t('app', 'Bloquear Acceso a Estudiantes'),
            'fallas' => Yii::t('app', 'Tipo de Fallas'),
            'frd' => Yii::t('app', 'Tipo de FRD'),
            'entrada' => Yii::t('app', 'Tipo de Entrada'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'ver_estandar' => Yii::t('app', 'Estandar'),
            'ver_competencia' => Yii::t('app', 'Competencia'),
            'ver_niveles' => Yii::t('app', 'Niveles'),
            'ver_desempenos' => Yii::t('app', 'Desempeños'),
            'ver_frd' => Yii::t('app', 'FRD'),
            'ver_criterios' => Yii::t('app', 'Criterios de Evaluación'),
            'ver_emoticones' => Yii::t('app', 'Emoticones'),
            'ver_puesto' => Yii::t('app', 'Puesto'),
            'activar_comportamiento' => Yii::t('app', 'Activar Comportamiento'), 
            'ver_comportamiento_nota' => Yii::t('app', 'Ver Nota'),
            'ver_comportamiento_general' => Yii::t('app', 'Ver Observación General'),
            'ver_comportamiento_especifico' => Yii::t('app', 'Ver Observación Especifica'),
            'activar_comportamiento' => Yii::t('app', 'Activar Comportamiento'),
        ];  
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupos()
    {
        return $this->hasMany(\backend\models\Grupo::className(), ['sede' => 'id']);
    }

    public function getDepartamentos()
    {
        return $this->hasOne(\backend\models\Departamento::className(), ['id' => 'departamento']);
    }
        
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMunicipios()
    {
        return $this->hasOne(\backend\models\Municipio::className(), ['id' => 'municipio']);
    } 
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
