<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

/**
 * This is the base model class for table "slide".
 *
 * @property integer $id
 * @property string $titulo
 * @property integer $tipo
 * @property string $enlace
 * @property string $target
 * @property string $descripcion
 * @property string $imagen
 * @property string $video
 * @property string $creado_el
 * @property integer $creado_por
 * @property string $actualizado_el
 * @property integer $actualizado_por
 * @property string $eliminado_el
 * @property integer $eliminado_por
 * @property integer $estado
 */
class Slide extends \yii\db\ActiveRecord
{
    use \mootensai\relation\RelationTrait;

    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            ''
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['titulo', 'tipo'], 'required'],
            [['tipo', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['enlace'], 'string'],
            [['creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['titulo', 'descripcion'], 'string', 'max' => 255],
            [['target'], 'string', 'max' => 10],
            
            //[['imagen'], 'image', 'skipOnEmpty' => true],
            [['video'], 'string', 'max' => 500],

            // CONDICIÓN DE IMAGEN
            [['imagen'], 'required', 'when' => function ($model) {
                return $model->tipo == '1';
            }, 'whenClient' => "function (attribute, value) {
                return $('#slide-tipo').val() == '1';
            }"],

            // CONDICIÓN DE VIDEO
            [['video'], 'required', 'when' => function ($model) {
                return $model->tipo == '2';
            }, 'whenClient' => "function (attribute, value) {
                return $('#slide-tipo').val() == '2';
            }"],

        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'slide';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'titulo' => Yii::t('app', 'Título'),
            'tipo' => Yii::t('app', 'Tipo'),
            'enlace' => Yii::t('app', 'Enlace'),
            'target' => Yii::t('app', 'Target'),
            'descripcion' => Yii::t('app', 'Descripción'),
            'imagen' => Yii::t('app', 'Imagen'),
            'video' => Yii::t('app', 'Video'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
