<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Tarea extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    
    public $rango;
    public $rango2;

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'docentes',
            'asignaturas',
            'grupos',
            'periodos',
            'tipos',
            'Desarrollos'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['docente', 'estudiante', 'asignatura', 'grupo', 'periodo', 'tipo', 'oportunidades','creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'],
            [['asignatura', 'grupo', 'periodo', 'descripcion','oportunidades', 'tarea', 'tipo', 'rango'], 'required'],
            [['descripcion', 'adjunto'], 'string'],
            [['disponible_desde', 'disponible_hasta', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'],
            [['tarea'], 'string', 'max' => 255]
        ];
    }


    public static function tableName()
    {
        return 'tarea';
    }


    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'docente' => Yii::t('app', 'Docente'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'asignatura' => Yii::t('app', 'Asignatura'),
            'grupo' => Yii::t('app', 'Grupo'),
            'periodo' => Yii::t('app', 'Periodo'),
            'tarea' => Yii::t('app', 'Tarea'),
            'tipo' => Yii::t('app', 'Tipo'),
            'descripcion' => Yii::t('app', 'Descripción'),
            'adjunto' => Yii::t('app', 'Adjunto'),
            'disponible_desde' => Yii::t('app', 'Disponible Desde'),
            'disponible_hasta' => Yii::t('app', 'Disponible Hasta'),
            'oportunidades' => Yii::t('app', 'Total de Oportunidades'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
            'rango' => Yii::t('app', 'Disponible Desde y Hasta'),
        ];
    }
    

    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'docente']);
    }
        
    
    public function getAsignaturas()
    {
        return $this->hasOne(\backend\models\Asignatura::className(), ['id' => 'asignatura']);
    }
        
    
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    
    public function getPeriodos()
    {
        return $this->hasOne(\backend\models\Periodo::className(), ['id' => 'periodo']);
    }
        
    
    public function getTipos()
    {
        return $this->hasOne(\backend\models\Tipotarea::className(), ['id' => 'tipo']);
    }
        
    
    public function getDesarrollos()
    {
        return $this->hasMany(\backend\models\Tareadesarrollo::className(), ['tarea' => 'id']);
    }
    
    /**
     * @inheritdoc
     * @return array mixed
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
