<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;


class Tareadesarrollo extends \yii\db\ActiveRecord
{
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/


    public function relationNames()
    {
        return [
            'tareas',
            'docentes',
            'estudiantes',
        ];
    }


    public function rules()
    {
        $rules = [];
        $rules[] = [['tarea', 'estudiante','desarrollo'], 'required'];
        $rules[] = [['tarea', 'estudiante', 'creado_por', 'actualizado_por', 'eliminado_por', 'estado'], 'integer'];
        $rules[] = [['desarrollo', 'adjunto', 'observaciones'], 'string'];
        $rules[] = [['visto_el', 'creado_el', 'actualizado_el', 'eliminado_el'], 'safe'];

        $tipo_calificacion = Grupo::find()->where(['id' => $this->tareas->grupo])->one()->grados->tipo_calificacion;


        if($tipo_calificacion == '1')
        {
            $rules[] =[['calificacion'], 'match', 'pattern' => '/^((NE)|(BJ)|(B)|(A)|(S))$/', 
            'message' => 'No Válida'];
        }


        if($tipo_calificacion == '2')
        {

            $rules[] =[['calificacion'], 'double', 
                    'min' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->min('limite_inferior'), 
                    'max' => Desempeno::find()->where(['tipo_calificacion' => $tipo_calificacion])->max('limite_superior'), 
                     ];            
        }

        $rules[] = [['calificacion'], 'required', 'on' => 'calificar'];

        return $rules;
    }


    public static function tableName()
    {
        return 'tarea_desarrollo';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'tarea' => Yii::t('app', 'Tarea'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'desarrollo' => Yii::t('app', 'Desarrollo'),
            'adjunto' => Yii::t('app', 'Adjunto'),
            'calificacion' => Yii::t('app', 'Calificación'),
            'observaciones' => Yii::t('app', 'Observaciones'),
            'revisado_por' => Yii::t('app', 'Revisado Por'),
            'revisado_el' => Yii::t('app', 'Revisado El'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    

    public function getTareas()
    {
        return $this->hasOne(\backend\models\Tarea::className(), ['id' => 'tarea']);
    }

    public function getDocentes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'revisado_por']);
    }

    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
    
    
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }
}
