<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use common\models\User;
use backend\models\TerceroQuery;
use backend\models\base\Authassignment;


class tercero extends \yii\db\ActiveRecord
{
    public $estudiante, $eliminado, $definitiva_periodo, $foto_anterior;
    
    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    public function relationNames()
    {
        return [
            'academicos',
            'academico',
            'grupos',
            'acudientes',
            'asistencias',
            'estudianteCalificaciones',
            'docenteCalificaciones',
            'calificacionCompromisos',
            'calificacionxcompetencias',
            'cargas',
            'director',
            'mensajesRecibidos',
            'mensajesEnviados',
            'observadores',
            'planAulas',
            'barrios',
            'tipoterceros',
            'estados',
            'situaciones',
            'estratos',
            'recursos',
            'municipioDesplazados',
            'departamentoDesplazados',
            'departamentoResguardos',
            'departamentos',
            'municipios',
            'capacidades',
            'resguardos',
            'departamentoresidencia',
            'municipioresidencia',
            'departamentoexpedido',
            'municipioexpedido',
            'generos',
            'rhs',
            'epss',
            'tipos',
            'etnias',
            'religiones',
            'sisben',
            'matriculas'
        ];
    } 
    public function rules()
    {
        
        return [
            [['identificacion', 'tipo', 'primer_nombre', 'primer_apellido', 'genero', 'tipo_tercero','pais'], 'required'],
            [['tipo', 'tipo_tercero', 'municipio_expedido', 'municipio_nacimiento', 'rh', 'religion', 'etnia', 'eps', 'barrio', 'estrato', 'codigo_sisben', 'situacion', 'cabeza_familia','municipio_desplazado', 'capacidad', 'discapacidad_certificada', 'subsidio', 'recurso', 'bienestar', 'heroe', 'fuerza_publica', 'sector', 'resguardo', 'cabeza_familia', 'vigencia_anterior_aprobada','creado_por', 'actualizado_por', 'eliminado_por', 'activo', 'estado','eliminado'], 'integer'],
            [['fecha_nacimiento', 'creado_el', 'creado_por', 'actualizado_el', 'actualizado_por','eliminado_el','eliminado_por'], 'safe'],
            [['codigo_desplazado', 'codigo_familia_accion'], 'string', 'max' => 20],
            [['primer_nombre', 'segundo_nombre', 'primer_apellido', 'segundo_apellido', 'direccion', 'foto', 'medicamentos', 'alergias', 'discapacidad'], 'string', 'max' => 255],
            [['genero'], 'string', 'max' => 1],
            [['firma'], 'string', 'max' => 255],
            [['departamento_expedido','departamento_nacimiento', 'departamento_desplazado', 'departamento_resguardo'], 'string', 'max' => 5],
            [['fijo', 'movil'], 'string', 'max' => 10],
            [['email'], 'email'],
            [['departamento_expedido','departamento_nacimiento', 'departamento_desplazado', 'departamento_resguardo'], 'default', 'value' => NULL],
            
            
            [['identificacion'], 'trim'],
            /*[['identificacion'], 'match', 'pattern' => '/^((\d{8})|(\d{10})|(\d{11})|(\d{6}-\d{5}))$/', 
                'message' => 'Número de Identificación no es válido.'],*/
            [['identificacion'], 'unique', 'message' => 'Este usuario ya ha sido creado.'],


            ////////    PASOS DE MATRICULA ESTUDIANTIL   ////////////
            [['identificacion', 'departamento_residencia', 'municipio_residencia','departamento_expedido', 'municipio_expedido', 'tipo', 'primer_nombre', 'primer_apellido', 'genero', 'tipo_tercero', 'pais', 'fecha_nacimiento', 'departamento_nacimiento', 'municipio_nacimiento', 'direccion', 'barrio', 'email', 'movil'], 'required', 'on' => 'step1'],
            [['rh', 'religion', 'etnia', 'eps', 'barrio', 'estrato', 'subsidio', 'recurso', 'bienestar', 'heroe', 'fuerza_publica', 'sector', 'cabeza_familia',], 'required', 'on' => 'step2'],
            [['foto'], 'file', 'extensions' => 'jpeg, jpg, png, gif','skipOnEmpty'=>true, 'on' => 'step5'],
            //[['foto'], 'required', 'on' => 'step5'],


        ];

    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'tercero';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'identificacion' => Yii::t('app', 'Número de Identificación'),
            'tipo' => Yii::t('app', 'Tipo de Identificación'),
            'departamento_expedido' => Yii::t('app', 'Departamento de Expedición'),
            'municipio_expedido' => Yii::t('app', 'Municipio de Expedición'),
            'primer_nombre' => Yii::t('app', 'Primer Nombre'),
            'segundo_nombre' => Yii::t('app', 'Segundo Nombre'),
            'primer_apellido' => Yii::t('app', 'Primer Apellido'),
            'segundo_apellido' => Yii::t('app', 'Segundo Apellido'),
            'genero' => Yii::t('app', 'Género'),
            'tipo_tercero' => Yii::t('app', 'Tipo de Tercero'),
            'fecha_nacimiento' => Yii::t('app', 'Fecha de Nacimiento'),
            'departamento_nacimiento' => Yii::t('app', 'Departamento de Nacimiento'),
            'municipio_nacimiento' => Yii::t('app', 'Municipio de Nacimiento'),
            'pais' => Yii::t('app', 'Nacionalidad'),
            'rh' => Yii::t('app', 'Grupo Sanguineo y Factor RH'),
            'religion' => Yii::t('app', 'Creencia Religiosa'),
            'etnia' => Yii::t('app', 'Grupo Étnico'),
            'eps' => Yii::t('app', 'Empresa Promotora de Salud'),
            'direccion' => Yii::t('app', 'Dirección de Residencia'),
            'departamento_residencia' => Yii::t('app', 'Departamento de Residencia'),
            'municipio_residencia' => Yii::t('app', 'Municipio de Residencia'),
            'barrio' => Yii::t('app', 'Barrio'),
            'fijo' => Yii::t('app', 'Télefono Fijo'),
            'movil' => Yii::t('app', 'Télefono Celular'),
            'email' => Yii::t('app', 'Correo Eléctronico'),
            'foto' => Yii::t('app', 'Foto'),
            'firma' => Yii::t('app', 'Firma'),
            'estrato' => Yii::t('app', 'Estrato'),
            'situacion' => Yii::t('app', 'Situación'),
            'codigo_desplazado' => Yii::t('app', 'Código Desplazado'),
            'departamento_desplazado' => Yii::t('app', 'Departamento Desplazado'),
            'municipio_desplazado' => Yii::t('app', 'Municipio Desplazamiento'),
            'codigo_sisben' => Yii::t('app', 'Grupo Sisben'),
            'codigo_familia_accion' => Yii::t('app', 'Código Familias en Acción'),
            'capacidad' => Yii::t('app', 'Capacidad Excepcional'),
            'medicamentos' => Yii::t('app', 'Medicamentos'),
            'alergias' => Yii::t('app', 'Alergias'),
            'discapacidad' => Yii::t('app', 'Discapacidad'),
            'discapacidad_certificada' => Yii::t('app', 'Discapacidad Certificada'),
            'subsidio' => Yii::t('app', 'Subsidio'),
            'recurso' => Yii::t('app', 'Recurso'),
            'bienestar' => Yii::t('app', 'Origen ICBF'),
            'heroe' => Yii::t('app', 'Beneficiario Héroes Nacionales'),
            'fuerza_publica' => Yii::t('app', 'Beneficiario Fuerza Pública'),
            'sector' => Yii::t('app', 'Sector'),
            'resguardo' => Yii::t('app', 'Resguardo'),
            'departamento_resguardo' => Yii::t('app', 'Departamento Resguardo'),
            'cabeza_familia' => Yii::t('app', 'Cabeza de Familia'),
            'creado_el' => Yii::t('app', 'Creado El'),
            'creado_por' => Yii::t('app', 'Creado Por'),
            'actualizado_el' => Yii::t('app', 'Actualizado El'),
            'actualizado_por' => Yii::t('app', 'Actualizado Por'),
            'eliminado_el' => Yii::t('app', 'Eliminado El'),
            'eliminado_por' => Yii::t('app', 'Eliminado Por'),
            'activo' => Yii::t('app', 'Activo'),
            'estado' => Yii::t('app', 'Estado'),
            'bloqueo' => Yii::t('app', 'Bloqueado'),
        ];
    }

    public function afterSave($insert, $changedAttributes) 
    {

        if($insert)
        {
            if($this->tipo_tercero < '4')
            {    
                $user = new User();
                $user->username = $this->identificacion;
                $user->email = $this->email;
                $user->setPassword($this->identificacion);
                $user->generateAuthKey();
                $user->save();

                switch ($this->tipo_tercero) {
                        case '1':
                            $perfil = "Estudiante";
                            break;
                        
                        case '2':
                            $perfil = "Docente";
                            break;
                        
                        case '3':
                            $perfil = "Administrativo";
                            break;
                        
                        default:
                            $perfil = "Estudiante";
                            break;
                    }


                    try {

                        $asignacion = new Authassignment();
                        $asignacion->item_name = $perfil;
                        $asignacion->user_id = $user->id;
                        $asignacion->created_at = strtotime("now");
                        $asignacion->save(false);

                    } catch (\yii\db\IntegrityException $e) {
                        //return $asignacion->error_reporting();
                        return 'ERROR ASIGNADO PERFIL';

                    }

                \Yii::$app->session->addFlash('mensaje1', [
                            'tipo' => 'info',
                            'titulo' => 'Creación de Usuario',
                            'icono' => 'fa fa-key',
                            'mensaje' => 'Se creó el usuario '.$this->identificacion.' para ingresar al sistema.']); 

                /*
                if($this->email != '')
                {    
                    \Yii::$app->mailer->compose('crea-tercero', ['model' => $this])
                        ->setFrom([\Yii::$app->params['supportEmail'] => \Yii::$app->name . ' robot'])
                        ->setTo($this->email)
                        ->setSubject('Creación de Usuario')
                        ->send();   
                
                    \Yii::$app->session->addFlash('mensaje2', [
                            'tipo' => 'info',
                            'titulo' => 'Notificación de E-Mail',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Se notificó por correo electrónico a '.$this->email.' la creación del usuario']);     

                }
                else 
                {     
                    \Yii::$app->session->addFlash('mensaje3', [
                            'tipo' => 'danger',
                            'titulo' => 'Notificación de E-Mail',
                            'icono' => 'fa fa-envelope',
                            'mensaje' => 'Oops!, no pude notificar la creación de usuario porque no tenia correo electrónico.']); 
                }  
                */      
            }
                        
        }
        parent::afterSave($insert, $changedAttributes); 
    }
/*
    public function beforeSave($insert,$changedAttributes)
    {
        //if (($this->scenario == 'user' || $this->scenario == 'guest') && $this->isNewRecord)    
        if ($this->isNewRecord)
            \Yii::$app->mailer->compose('crea-tercero', ['nombre' => $this->nombre, 'identificacion' => $this->identificacion])
                ->setFrom([\Yii::$app->params['supportEmail'] => \Yii::$app->name . ' robot'])
                ->setTo('acosta@gsolcolombia.com')
                ->setSubject('Creación de Usuario after')
                ->send();
        parent::beforeSave($insert,$changedAttributes);
    }
*/
    public function getNombre()
    {
        //return $this->primer_nombre.' '.$this->segundo_nombre.' '.$this->primer_apellido.' '.$this->segundo_apellido;
        return $this->primer_apellido.' '.$this->segundo_apellido.' '.$this->primer_nombre.' '.$this->segundo_nombre;
    }

    public function getNombreinverso()
    {
        return $this->primer_apellido.' '.$this->segundo_apellido.' '.$this->primer_nombre.' '.$this->segundo_nombre;
    }

    public function getNombreGrupo()
    {
        $grupo = Academico::find()->where(['estudiante' => $this->id])->select(['grupo'])->one(); 
        return $this->primer_nombre.' '.$this->segundo_nombre.' '.$this->primer_apellido.' '.$this->segundo_apellido.' ('.$grupo ? $grupo->grupo : 'Sin Grupo'.')';
    }

    public function getNombreinversoGrupo()
    {
        $grupo = Academico::find()->where(['estudiante' => $this->id])->select(['grupo'])->one(); 
        return $this->primer_apellido.' '.$this->segundo_apellido.' '.$this->primer_nombre.' '.$this->segundo_nombre.' ('.$grupo ? $grupo->grupo : 'Sin Grupo'.')';
    }

    public function getObservadores()
    {
        return $this->hasMany(\backend\models\Observador::className(), ['estudiante' => 'id']);
    } 

    public function getNotificacion()
    {
        return $this->email;
    }

    public function getSms()
    {
        return $this->movil;
    }

    public function getGrupoid() 
    {
        //$grupo = Academico::find()->where(['estudiante' => $this->id])->select(['grupo'])->one();
        $grupo = Academico::find()->where(['estudiante' => $this->id])->one();
        //$data = Grupo::find()->where(['id' => $id_grupo])->select(['id', 'grupo'])->one();

        //    return $grupo->grupo;
        return $grupo ? intval($grupo->grupo) : 0; 
        //return $grupo->total;
    }

    public function getGrupoaaaa() 
    {
        $grupo = Academico::find()->where(['estudiante' => $this->id])->select(['grupo'])->one();
        //$data = Grupo::find()->where(['id' => $id_grupo])->select(['id', 'grupo'])->one();

        //    return $grupo->grupo;
        
        return $grupo ? $grupo->grupos->grupo : '0'; 
    }

    public function getGrupo() 
    {
        $academico = Academico::find()->where(['estudiante' => $this->id])->select(['grupo'])->one();
        
        if($academico !== null)
        {
            $grupo = Grupo::find()->where(['id' => $academico->grupo])->one();
            return $grupo;    
        }
        else
        {
            return false;
        }
    }



    public function getAsiganturasxEspecialidad() 
    {
        $asignaturas = Asignatura::find()
                    ->andWhere(['grado' => $this->academico->grupos->grado])
                    ->andWhere(['especialidad' => $this->academico->especialidad])
                    ->orderBy(['area' => SORT_ASC])
                    ->all();

        return $asignaturas;
    }

    public function getAsiganturasxEspecialidadNoExcluida() 
    {
        $asignaturas = Asignatura::find()
                    ->andWhere(['grado' => $this->academico->grupos->grado])
                    ->andWhere(['especialidad' => $this->academico->especialidad])
                    ->andWhere(['excluida_promocion' => '0'])
                    ->orderBy(['area' => SORT_ASC])
                    ->all();

        return $asignaturas;
    }


    public function Promedioarea($estudiante, $area, $periodo = '5', $tipo_calificacion) 
    {        
        if (($promedio = Promedioarea::find()
                ->where(['estudiante' => $estudiante])
                ->andwhere(['area' => $area])
                ->andwhere(['periodo' => $periodo])
                ->select(['promedio_estudiante'])
                ->one()) !== NULL)
        {

            if($tipo_calificacion == '1')
            {
                return $promedio->promedio_estudiante != '' ? $promedio->promedio_estudiante : 'NE';     
            }
            else
            {
                return '0';
            }
        }
        else
        {
            if($tipo_calificacion == '1')
            {
                return 'NE';
            }
            else
            {
                return '0';
            }
        }    
    }

    public function getTotalasignaturas() 
    {
        $grupo = Academico::find()->where(['estudiante' => $this->id])->select(['grupo'])->one();

        return count($grupo->grupos->grados->asignaturas); 
        
    }

    public function getUsuario() 
    {
        $user = User::find()->where(['username' => $this->identificacion])->one();
   
        return $user; 
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicos()
    {
        return $this->hasMany(\backend\models\Academico::className(), ['estudiante' => 'id']);
    }

    public function getAcademico()
    {
        return $this->hasOne(\backend\models\Academico::className(), ['estudiante' => 'id'])->andWhere(['eliminado_por' => 0]);
    }

    public function getMatriculas()
    {
        return $this->hasOne(\backend\models\Matricula::className(), ['estudiante' => 'id']);
    }

    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Academico::className(), ['estudiante' => 'id']);
    }

    public function getAcudientes()
    {
        //return $this->hasMany(\backend\models\Acudiente::className(), ['estudiante' => 'id']);
        return $this->hasMany(\backend\models\Acudiente::className(), ['estudiante' => 'id'])->andWhere(['eliminado_por' => 0]);
    } 

    public function getAcudiente()
    {
        //return $this->hasMany(\backend\models\Acudiente::className(), ['estudiante' => 'id']);
        return $this->hasOne(\backend\models\Acudiente::className(), ['estudiante' => 'id'])->andWhere(['principal' => '1'])->andWhere(['eliminado_por' => 0]);
    }

    public function getAcudientesnoprincipal()
    {
        //return $this->hasMany(\backend\models\Acudiente::className(), ['estudiante' => 'id']);
        return $this->hasMany(\backend\models\Acudiente::className(), ['estudiante' => 'id'])->andWhere(['principal' => '0'])->andWhere(['eliminado_por' => 0]);
    } 
    
    public function getAsistencias()
    {
        return $this->hasMany(\backend\models\Asistencia::className(), ['estudiante' => 'id']);
    }

    public function getCalificacionCompromisos()
    {
        return $this->hasMany(\backend\models\Calificacioncompromisos::className(), ['estudiante' => 'id']);
    } 

    public function getCalificacionxcompetencias()
    {
        return $this->hasMany(\backend\models\Calificacionxcompetencia::className(), ['docente' => 'id']);
    }
    
    public function getDocenteCalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacion::className(), ['docente' => 'id']);
    }

    public function getEstudianteCalificaciones()
    {
        return $this->hasMany(\backend\models\Calificacion::className(), ['estudiante' => 'id']);
    }

    public function getCargas()
    {
        return $this->hasMany(\backend\models\Carga::className(), ['docente' => 'id']);
    } 
    
    public function getDirector()
    {
        return $this->hasMany(\backend\models\Grupo::className(), ['director' => 'id'])->andWhere(['eliminado_por' => '0']);
    }

    public function getBarrios()
    {
        return $this->hasOne(\backend\models\Barrio::className(), ['id' => 'barrio']);
    }

    public function getTipoterceros()
    {
        return $this->hasOne(\backend\models\Tipotercero::className(), ['id' => 'tipo_tercero']);
    }

    public function getMunicipios()
    {
        return $this->hasOne(\backend\models\Municipio::className(), ['id' => 'municipio_nacimiento']);
    }

    public function getGeneros()
    {
        return $this->hasOne(\backend\models\Genero::className(), ['id' => 'genero']);
    }

    public function getPaises()
    {
        return $this->hasOne(\backend\models\Pais::className(), ['codigo' => 'pais']);
    }

    public function getDepartamentos()
    {
        return $this->hasOne(\backend\models\Departamento::className(), ['id' => 'departamento_nacimiento']);
    }

    public function getRhs()
    {
        return $this->hasOne(\backend\models\Rh::className(), ['id' => 'rh']);
    }

    public function getEpss()
    {
        return $this->hasOne(\backend\models\Eps::className(), ['id' => 'eps']);
    }

    public function getTipos()
    {
        return $this->hasOne(\backend\models\Tipodocumento::className(), ['id' => 'tipo']);
    }

    public function getEtnias()
    {
        return $this->hasOne(\backend\models\Etnia::className(), ['id' => 'etnia']);
    }

    public function getReligiones()
    {
        return $this->hasOne(\backend\models\Religion::className(), ['id' => 'religion']);
    }

    public function getEstados()
    {
        return $this->hasOne(\backend\models\Terceroestado::className(), ['id' => 'estado']);
    }

    public function getPlanAulas()
    {
        return $this->hasMany(\backend\models\Planaula::className(), ['docente' => 'id']);
    } 

    public function getMensajesEnviados()
    {
        return $this->hasMany(\backend\models\base\Mensajes::className(), ['remitente' => 'id']);
    } 

    public function getMensajesRecibidos()
    {
        return $this->hasMany(\backend\models\base\Mensajes::className(), ['remisor' => 'id']);
    }

    public function getSituaciones()
    {
        return $this->hasOne(\backend\models\Tiposituacion::className(), ['id' => 'situacion']);
    }
        
    public function getEstratos()
    {
        return $this->hasOne(\backend\models\Estrato::className(), ['id' => 'estrato']);
    }

    public function getCapacidades()
    {
        return $this->hasOne(\backend\models\Tipocapacidad::className(), ['id' => 'capacidad']);
    }

    public function getSisben()
    {
        return $this->hasOne(\backend\models\Tiposisben::className(), ['id' => 'codigo_sisben']);
    }

    public function getRecursos()
    {
        return $this->hasOne(\backend\models\Tiporecurso::className(), ['id' => 'recurso']);
    }

    public function getDepartamentoexpedido()
    {
        return $this->hasOne(\backend\models\Departamento::className(), ['id' => 'departamento_expedido']);
    }    
        
    public function getMunicipioexpedido()
    {
        return $this->hasOne(\backend\models\Municipio::className(), ['id' => 'municipio_expedido']);
    }

    public function getDepartamentoresidencia()
    {
        return $this->hasOne(\backend\models\Departamento::className(), ['id' => 'departamento_residencia']);
    }    
        
    public function getMunicipioresidencia()
    {
        return $this->hasOne(\backend\models\Municipio::className(), ['id' => 'municipio_residencia']);
    }

    public function getDepartamentoDesplazados()
    {
        return $this->hasOne(\backend\models\Departamento::className(), ['id' => 'departamento_desplazado']);
    }    
        
    public function getMunicipioDesplazados()
    {
        return $this->hasOne(\backend\models\Municipio::className(), ['id' => 'municipio_desplazado']);
    }
    
    public function getResguardos()
    {
        return $this->hasOne(\backend\models\Resguardo::className(), ['id' => 'resguardo']);
    }

    public function getDepartamentoResguardos()
    {
        return $this->hasOne(\backend\models\Departamento::className(), ['id' => 'departamento_resguardo']);
    }
    
    public function getMunicipioResguardos()
    {
        return $this->hasOne(\backend\models\Municipio::className(), ['id' => 'municipio_resguardo']);
    }
                

    public function behaviors()
    {
        return [
            [
                'class' => TimestampBehavior::className(),
                'createdAtAttribute' => 'creado_el',
                'updatedAtAttribute' => 'actualizado_el',
                'value' => new \yii\db\Expression('NOW()'),
            ],
            [
                'class' => BlameableBehavior::className(),
                'createdByAttribute' => 'creado_por',
                'updatedByAttribute' => 'actualizado_por',
            ],
        ];
    }

    /**
     * @inheritdoc
     * @return \backend\models\terceroQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new terceroQuery(get_called_class());
    }
}
