<?php

namespace backend\models\base;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;

/**
 * This is the base model class for table "tercero_estado".
 *
 * @property integer $id
 * @property integer $tipo_tercero
 * @property string $estado
 *
 * @property \backend\models\Tercero[] $terceros
 * @property \backend\models\Tipotercero $tipoTercero
 */
class Terceroestado extends \yii\db\ActiveRecord
{

    /* use \mootensai\relation\RelationTrait;*/

    /*
    private $_rt_softdelete;
    private $_rt_softrestore;

    public function __construct(){
        parent::__construct();
        $this->_rt_softdelete = [
            'eliminado_por' => \Yii::$app->user->id,
            'eliminado_el' => new \yii\db\Expression('NOW()'),
        ];
        $this->_rt_softrestore = [
            'eliminado_por' => 0,
            'eliminado_el' => date('Y-m-d H:i:s'),
        ];
    }*/

    /**
    * This function helps \mootensai\relation\RelationTrait runs faster
    * @return array relation names of this model
    */
    public function relationNames()
    {
        return [
            'terceros',
            'tipoterceros'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tipo_tercero', 'estado'], 'required'],
            [['tipo_tercero','retiro'], 'integer'],
            [['estado'], 'string', 'max' => 255]
        ];
    }
    
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'tercero_estado';
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'tipo_tercero' => Yii::t('app', 'Tipo Tercero'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTerceros()
    {
        return $this->hasMany(\backend\models\Tercero::className(), ['estado' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTipoterceros()
    {
        return $this->hasOne(\backend\models\Tipotercero::className(), ['id' => 'tipo_tercero']);
    }


    public static function find()
    {
        return new \backend\models\TerceroestadoQuery(get_called_class());
    }
}
