<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use yii2mod\google\maps\markers\GoogleMaps;

use backend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Grupo;
use backend\models\Academico;
use yii\db\Expression;



?>

         <?php $form = ActiveForm::begin([
            //'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>


<div class="row gutter">
  <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
    <div class="thumbnail">
      <?
            if (!$model->isNewRecord)
            {
                echo Html::img($model->estudiantes->foto ? '@web/uploads/thumbnail/sm-'.$model->estudiantes->foto : '@web/images/user.jpg', ['class'=>'foto-perfil img-circle img-responsive']); 

                echo "<div class='clear'></div>";
                
                echo '<h4 class="center-align-text">'.$model->estudiantes->nombre.'</h4>';
            }
            elseif (isset($tercero) && !$tercero->isNewRecord)
            {
                echo Html::img($tercero->foto ? '@web/uploads/thumbnail/sm-'.$tercero->foto : '@web/images/user.jpg', ['class'=>'foto-perfil img-circle img-responsive']); 

                echo "<div class='clear'></div>";
                
                echo '<h4 class="center-align-text">'.$tercero->nombre.'</h4>';
            } 
            else
            {
                echo Html::img('@web/images/matricula-estudiantil.png', ['class'=>'img-responsive']);
            }
      ?>               
        
        <div class="clear"></div> 

        <!--
        <div class="progress m-t-xs full progress-small">
            <div style="width: 65%" aria-valuemax="100" aria-valuemin="0" aria-valuenow="65" role="progressbar" class=" progress-bar progress-bar-success">
                <span class="sr-only">35% Complete (success)</span>
            </div>
        </div>
        -->

        <div class="clear"></div> 

        <? if (!$model->isNewRecord) { ?>
            
            <p class="center-align-text" style="padding: 10px;">
                            
                <? 

                    if ($model->estudiantes->estados->retiro == 1)
                    {
                        echo "<label class='btn btn-block btn-danger'>".$model->estudiantes->estados->estado."</label>";
                    }
                    else    
                    {
                        echo "<label class='btn btn-block btn-info'>".$model->estudiantes->estados->estado."</label>";
                    }    
                ?>

                <?php
                        if ($model->aprobo == NULL) 
                        {
                            echo '<label class="btn btn-block btn-warning">Año en Curso</label>';
                        }
                        elseif($model->aprobo == 'S')
                        {
                            echo '<label class="btn btn-block btn-success">Año Aprobado</label>';
                        }
                        elseif ($model->aprobo == 'N') 
                        {
                            echo '<label class="btn btn-block btn-danger">Año Reprobado</label>';
                        }
                ?>

                <? 

                    if ($model->grupo == NULL)
                    {
                        echo "<label class='btn btn-block btn-danger'>Sin Grupo</label>";
                    }
                    else    
                    {
                        echo "<label class='btn btn-block btn-info'>Grupo " .$model->grupos->grupo. "</label>";
                    }    
                ?>
            
                <?= Html::a('<i class="far fa-print fa-lg"></i> Certificado de Matrícula', ['tercero/hojadevida', 'id' => $model->estudiante], ['class' => 'btn btn-block btn-primary', 'data-toggle' => 'modal', 'data-target' => '#modal','data-toggle' => 'tooltip', 'title' => 'Certificado de Matrícula', 'target' => 'modal']); ?>
                
                
          </p>

        <?
            }
        ?>  

        <? if (isset($tercero) && !$tercero->isNewRecord) { ?>
            
            <p class="btn-stack center-align-text">
            
                <? 
                    $data = Academico::find()->where(['estudiante' => $tercero->id])->one();

                    if ($data == NULL)
                    {
                        echo "<label class='btn btn-danger'>Sin Grupo</label>";
                    }
                    else    
                    {
                        echo "<label class='btn btn-info'>Grupo " .$data->grupos->grupo. "</label>";
                    }    
                ?>
            
            <?= Html::a('<i class="fa fa-file-o fa-lg"></i> Certificado de Matrícula', ['tercero/hojadevida', 'id' => $tercero->id], ['class' => 'btn btn-md btn-danger', 'data-toggle' => 'modal', 'data-target' => '#modal','data-toggle' => 'tooltip', 'title' => 'Exportar Hoja de Vida', 'target' => 'modal']); ?>

          </p>

        <?
            }
        ?>  

    </div>
    <br>
  </div>

            
  <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#tab-1">Matricula Estudiantil</a></li>
        <li class="danger"><a data-toggle="tab" href="#tab-2">Retiro Estudiantil</a></li>
        
    </ul>
    <div class="tab-content">
        <div id="tab-1" class="tab-pane active">

            <div class="row">

                <?  

                    if(!$model->isNewRecord)
                    {
                        echo $form->field($model, 'estudiante')->hiddenInput(['value'=> $model->estudiante])->label(false);
                    }
                    elseif(isset($tercero) && !$tercero->isNewRecord)
                    {
                        echo $form->field($model, 'estudiante')->hiddenInput(['value'=> $tercero->id])->label(false);
                    }
                    else
                    {
                        $query = Tercero::find()->select(['tercero.id', new Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->leftjoin('academico', 'academico.estudiante = tercero.id')->Where(['tercero.tipo_tercero' => '1'])->orWhere(['tercero.estado' => '9'])->orWhere(['<', 'tercero.estado', '3'])->andWhere(['is', 'academico.id', null])->orderBy('tercero.primer_apellido')->asArray()->all();
                        
                        echo '<div class="col-sm-12">';
                        echo $form->field($model, 'estudiante')->widget(Select2::classname(), [
                            'data' => ArrayHelper::map($query, 'id', 'nombre'),
                            'options' => ['placeholder' => 'Seleccione el Estudiante'],
                            'hideSearch' => false,
                            'pluginOptions' => [
                                'allowClear' => true,
                            ],
                        ]);
                        echo '</div>';
                    }    
                ?>
                <div class="col-sm-6">
                    <?= $form->field($model, 'grupo')->widget(\kartik\widgets\Select2::classname(), [
                        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                        'options' => ['placeholder' => 'Seleccione Grupo'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>                    
                </div>
                <div class="col-sm-6">
                    <?= $form->field($model, 'fecha_matricula')->widget(DatePicker::classname(), [
                        'options' => ['placeholder' => 'Seleccione la Fecha de Matricula'],
                        'removeButton' => false,
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'yyyy-mm-dd',
                            'todayHighlight' => true            ]
                    ]) ?>
                </div>
            </div>

            <?= $form->field($model, 'grupo_old')->hiddenInput()->label(false); ?>

        </div>  <!-- FIN TAB 1  -->
        <div id="tab-2" class="tab-pane">

            <div class="row">

                <div class="col-sm-6">
                    <?= $form->field($model, 'fecha_retiro')->widget(DatePicker::classname(), [
                        'options' => ['placeholder' => 'Seleccione la Fecha de Retiro'],
                        'removeButton' => false,
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'yyyy-mm-dd',
                            'todayHighlight' => true            ]
                    ]) ?>
                </div>
                
                <?
                    if (!$model->isNewRecord)
                    {
                        if ($model->estudiantes->estados->retiro == 1)
                        {
                            $model->motivo = $model->estudiantes->estado;
                        }
                    }
                ?>        
                <div class="col-sm-6">
                    <?= $form->field($model, 'motivo')->widget(Select2::classname(), [
                        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Terceroestado::find()->where(['retiro' => '1'])->orderBy('estado')->asArray()->all(), 'id', 'estado'),
                        'options' => ['placeholder' => 'Seleccione el Motivo del Retiro'],
                        'hideSearch' => isset($tercero) ? true : false,
                        'pluginOptions' => [
                            'allowClear' => isset($tercero) ? false : true,
                        ],
                    ]);?>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>




    <?php ActiveForm::end(); ?>
